/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core.desc;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Category {
    private static final Logger LOG = Logger.getLogger(Category.class.getName());
    private final String name;
    private final String icon;
    private final ClassLoader classLoader;

    public Category(String name, String icon, ClassLoader classLoader) {
        this.name = name;
        this.icon = icon;
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.name;
    }

    public String getIconPath() {
        return this.icon;
    }

    public InputStream getIcon() {
        if (this.icon != null && !"".equals(this.icon.trim())) {
            ClassLoader loader = this.classLoader;
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            try {
                return loader.getResourceAsStream(this.icon);
            }
            catch (RuntimeException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Icon Of the category " + this.name + " cannot be loaded", e);
                }
                return null;
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

