/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Iterator;
import java.util.List;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class AutomaticActivity
extends AbstractActivity {
    private static final long serialVersionUID = -6392840287035678094L;

    protected AutomaticActivity() {
    }

    public AutomaticActivity(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition activityDefinition = execution.getNode();
        InternalActivityInstance activity = execution.getActivityInstance();
        if (activityDefinition.isAsynchronous()) {
            if (this.hasConnectorsAutomaticOnEnter(activityDefinition)) {
                if (!ActivityState.ABORTED.equals((Object)activity.getState())) {
                    EventService eventService = EnvTool.getEventService();
                    String eventName = "**bonita_connector_automatic_on_enter**-" + activity.getUUID();
                    Job job = JobBuilder.connectorsAutomaticOnEnterJob(eventName, execution.getInstance().getRootInstanceUUID(), execution.getEventUUID(), execution.getInstance().getProcessInstanceUUID());
                    eventService.storeJob(job);
                }
                return false;
            }
        } else {
            ConnectorExecutor.executeConnectors(activityDefinition, execution, HookDefinition.Event.automaticOnEnter);
        }
        ConnectorExecutor.executeConnectors(activityDefinition, execution, HookDefinition.Event.automaticOnExit);
        return !ActivityState.ABORTED.equals((Object)activity.getState());
    }

    private boolean hasConnectorsAutomaticOnEnter(InternalActivityDefinition activityDefinition) {
        List<HookDefinition> connectors = activityDefinition.getConnectors();
        Iterator<HookDefinition> iterator = connectors.iterator();
        boolean hasConnectorsOnEnter = false;
        while (!hasConnectorsOnEnter && iterator.hasNext()) {
            HookDefinition connector = iterator.next();
            if (!HookDefinition.Event.automaticOnEnter.equals((Object)connector.getEvent())) continue;
            hasConnectorsOnEnter = true;
        }
        return hasConnectorsOnEnter;
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }
}

