/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ActivityUtil;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class ReceiveEvent
extends AbstractActivity {
    private static final long serialVersionUID = 477565487347215726L;
    protected static final Logger LOG = Logger.getLogger(ReceiveEvent.class.getName());

    protected ReceiveEvent() {
    }

    public ReceiveEvent(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition activity = execution.getNode();
        ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
        EventService eventService = EnvTool.getEventService();
        IncomingEventDefinition incomingEvent = activity.getIncomingEvent();
        String eventUUID = execution.getEventUUID();
        if (eventUUID == null) {
            eventUUID = UUID.randomUUID().toString();
        }
        ProcessInstanceUUID instanceUUID = execution.getInstance().getUUID();
        IncomingEventInstance eventInstance = new IncomingEventInstance(incomingEvent.getName(), incomingEvent.getExpression(), instanceUUID, activity.getUUID(), activityUUID, execution.getProcessDefinition().getName(), this.activityName, eventUUID, "intermediate", System.currentTimeMillis(), true);
        ActivityUtil.addCorrelationKeys(incomingEvent, (EventInstance)eventInstance, activityUUID);
        execution.setEventUUID(eventUUID);
        execution.lock("Incoming event " + eventUUID);
        eventService.subscribe(eventInstance);
        return false;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if ("message".equals(signal)) {
            Authentication.setUserId("SYSTEM");
            ConnectorExecutor.executeConnectors(execution.getNode(), execution, HookDefinition.Event.onEvent, signalParameters);
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

