/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.deployment;

public class BARVersion
implements Comparable<String> {
    private final String formattedVersion;

    public BARVersion(String version) {
        this.formattedVersion = this.format(version);
    }

    @Override
    public int compareTo(String version) {
        String otherFormatedVersion = this.format(version);
        return this.formattedVersion.compareTo(otherFormatedVersion);
    }

    private String format(String version) {
        if (version == null) {
            throw new IllegalArgumentException("The version cannot be null");
        }
        String trimVersion = version.trim();
        if (version.endsWith(".0")) {
            trimVersion = version.substring(0, version.length() - 2);
        }
        String[] split = trimVersion.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String s : split) {
            builder.append(String.format("%4s", s));
        }
        return builder.toString();
    }
}

