/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.PvmEnvironmentFactory;
import org.ow2.bonita.env.PvmEnvironmentFactoryParser;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.env.xml.BindingParser;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Parse;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BonitaEnvironmentParser
extends PvmEnvironmentFactoryParser {
    public static final String CLASSPATH_URL = "classpath://";
    private static final Logger LOG = Logger.getLogger(BonitaEnvironmentParser.class.getName());
    private static PvmEnvironmentFactoryParser instance;
    public static final String BONITA_WIRE_BINDINGS_RESOURCES = "bonita.wire.bindings.xml";

    public static synchronized PvmEnvironmentFactoryParser getInstance() {
        if (instance == null) {
            instance = new BonitaEnvironmentParser();
            Bindings bindings = instance.getEnvironmentXmlParser().getBindings();
            instance.getEnvironmentFactoryXmlParser().setBindings(bindings);
            BindingParser bindingParser = new BindingParser();
            URL url = ReflectUtil.getResource(null, BONITA_WIRE_BINDINGS_RESOURCES);
            if (url != null) {
                LOG.info("parsing bindings from resource url: " + url);
                Parse parse = bindingParser.createParse().setUrl(url).pushObject(bindings).execute();
                Misc.showProblems(parse.getProblems(), "bonita wire bindings");
            }
        }
        return instance;
    }

    @Override
    public PvmEnvironmentFactory parseDocument(Document document, Parse parse) {
        PvmEnvironmentFactory defaultEnvironmentFactory = (PvmEnvironmentFactory)super.parseDocument(document, parse);
        ObjectDescriptor authenticationDescriptor = new ObjectDescriptor();
        authenticationDescriptor.setClassName(Authentication.class.getName());
        defaultEnvironmentFactory.getEnvironmentFactoryCtxWireContext().getWireDefinition().addDescriptor(authenticationDescriptor);
        return defaultEnvironmentFactory;
    }

    public static EnvironmentFactory parseEnvironmentFactoryFromXmlString(String xmlString) {
        Parse parse = BonitaEnvironmentParser.getInstance().createParse();
        parse.setString(xmlString);
        EnvironmentFactory factory = (EnvironmentFactory)parse.execute().getDocumentObject();
        Misc.showProblems(parse.getProblems(), "environment");
        return factory;
    }

    @Override
    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        this.documentBuilderFactory = this.newDocumentBuilderFactory();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setValidating(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        URL url = BonitaEnvironmentParser.class.getClassLoader().getResource("bonita-environment.xsd");
        if (url == null) {
            String message = ExceptionManager.getInstance().getFullMessage("benv_XEP_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", url.toExternalForm());
        return this.documentBuilderFactory;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.startsWith(CLASSPATH_URL)) {
            String localpart = systemId.substring(CLASSPATH_URL.length());
            InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(localpart);
            if (inStream != null) {
                return new InputSource(inStream);
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

