/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.AbstractDescriptor;
import org.ow2.bonita.env.descriptor.PropertiesDescriptor;
import org.ow2.bonita.env.operation.Operation;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.ReflectUtil;

public class HibernateConfigurationDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateConfigurationDescriptor.class.getName());
    String className;
    String namingStrategyClassName;
    List<Operation> mappingOperations;
    List<Operation> cacheOperations;
    PropertiesDescriptor propertiesDescriptor;
    private Operation schemaOperation;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        if (this.className != null) {
            ClassLoader classLoader = wireContext.getClassLoader();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("instantiating hibernate configation class " + this.className);
            }
            Class<?> configurationClass = ReflectUtil.loadClass(classLoader, this.className);
            configuration = (Configuration)ReflectUtil.newInstance(configurationClass);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("instantiating default hibernate configation");
            }
            configuration = new Configuration();
        }
        return configuration;
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Configuration configuration = (Configuration)object;
        this.apply(this.mappingOperations, configuration, wireContext);
        this.apply(this.cacheOperations, configuration, wireContext);
        if (this.propertiesDescriptor != null) {
            Properties properties = (Properties)wireContext.create(this.propertiesDescriptor, false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding properties to hibernate configuration: " + properties);
            }
            configuration.addProperties(properties);
        }
        if (this.schemaOperation != null) {
            this.schemaOperation.apply(configuration, wireContext);
        }
    }

    private void apply(List<Operation> operations, Configuration configuration, WireContext wireContext) {
        if (operations != null) {
            for (Operation operation : operations) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(operation.toString());
                }
                operation.apply(configuration, wireContext);
            }
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        if (this.className != null) {
            try {
                return ReflectUtil.loadClass(wireDefinition.getClassLoader(), this.className);
            }
            catch (BonitaRuntimeException e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_HCD_1", this.className, e.getMessage());
                throw new WireException(message, e.getCause());
            }
        }
        return Configuration.class;
    }

    public void addMappingOperation(Operation operation) {
        if (this.mappingOperations == null) {
            this.mappingOperations = new ArrayList<Operation>();
        }
        this.mappingOperations.add(operation);
    }

    public void addCacheOperation(Operation operation) {
        if (this.cacheOperations == null) {
            this.cacheOperations = new ArrayList<Operation>();
        }
        this.cacheOperations.add(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SQLException> executeScript(Connection connection, String[] script) throws SQLException {
        List<SQLException> exceptions = Collections.emptyList();
        Statement statement = connection.createStatement();
        try {
            for (String line : script) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(line);
                }
                try {
                    statement.executeUpdate(line);
                    if (statement.getWarnings() == null) continue;
                    JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                }
                catch (SQLException e) {
                    if (exceptions.isEmpty()) {
                        exceptions = new ArrayList<SQLException>();
                    }
                    exceptions.add(e);
                }
            }
        }
        finally {
            statement.close();
        }
        return exceptions;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public PropertiesDescriptor getPropertiesDescriptor() {
        return this.propertiesDescriptor;
    }

    public void setPropertiesDescriptor(PropertiesDescriptor propertiesDescriptor) {
        this.propertiesDescriptor = propertiesDescriptor;
    }

    public String getNamingStrategyClassName() {
        return this.namingStrategyClassName;
    }

    public void setNamingStrategyClassName(String namingStrategyClassName) {
        this.namingStrategyClassName = namingStrategyClassName;
    }

    public Operation getSchemaOperation() {
        return this.schemaOperation;
    }

    public void setSchemaOperation(Operation schemaOperation) {
        this.schemaOperation = schemaOperation;
    }

    public static final class UpdateSchema
    implements Operation {
        private static final long serialVersionUID = 1L;
        private static final Operation INSTANCE = new UpdateSchema();

        private UpdateSchema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            Properties cfgProperties = configuration.getProperties();
            Dialect dialect = Dialect.getDialect((Properties)cfgProperties);
            ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)cfgProperties);
            try {
                Connection connection = connectionProvider.getConnection();
                try {
                    DatabaseMetadata metadata = new DatabaseMetadata(connection, dialect);
                    String[] updateScript = configuration.generateSchemaUpdateScript(dialect, metadata);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("updating db schema");
                    }
                    HibernateConfigurationDescriptor.executeScript(connection, updateScript);
                }
                finally {
                    connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_HCD_5", new Object[0]);
                throw new JDBCException(message, e);
            }
            finally {
                connectionProvider.close();
            }
        }

        public static Operation getInstance() {
            return INSTANCE;
        }
    }

    public static final class CreateSchema
    implements Operation {
        private static final long serialVersionUID = 1L;
        private static final Operation INSTANCE = new CreateSchema();

        private CreateSchema() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            Properties cfgProperties = configuration.getProperties();
            Dialect dialect = Dialect.getDialect((Properties)cfgProperties);
            ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)cfgProperties);
            try {
                Connection connection = connectionProvider.getConnection();
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("dropping db schema");
                    }
                    String[] dropScript = configuration.generateDropSchemaScript(dialect);
                    HibernateConfigurationDescriptor.executeScript(connection, dropScript);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("creating db schema");
                    }
                    String[] createScript = configuration.generateSchemaCreationScript(dialect);
                    HibernateConfigurationDescriptor.executeScript(connection, createScript);
                }
                finally {
                    connectionProvider.closeConnection(connection);
                }
            }
            catch (SQLException e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_HCD_4", new Object[0]);
                throw new JDBCException(message, e);
            }
            finally {
                connectionProvider.close();
            }
        }

        public static Operation getInstance() {
            return INSTANCE;
        }
    }

    public static class SetCollectionCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        String collection;
        String concurrencyStrategy;

        public SetCollectionCacheConcurrencyStrategy(String collection, String concurrencyStrategy) {
            this.collection = collection;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCollectionCacheConcurrencyStrategy(this.collection, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on collection " + this.collection + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class SetCacheConcurrencyStrategy
    implements Operation {
        private static final long serialVersionUID = 1L;
        String className;
        String concurrencyStrategy;

        public SetCacheConcurrencyStrategy(String className, String concurrencyStrategy) {
            this.className = className;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.setCacheConcurrencyStrategy(this.className, this.concurrencyStrategy);
        }

        public String toString() {
            return "setting cache concurrency strategy on class " + this.className + " to " + this.concurrencyStrategy + " on hibernate configuration";
        }
    }

    public static class AddUrl
    implements Operation {
        private static final long serialVersionUID = 1L;
        String url;

        public AddUrl(String url) {
            this.url = url;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                configuration.addURL(new URL(this.url));
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_HCD_3", this.url);
                throw new BonitaRuntimeException(message, e);
            }
        }
    }

    public static class AddClass
    implements Operation {
        private static final long serialVersionUID = 1L;
        String className;

        public AddClass(String className) {
            this.className = className;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            try {
                Class<?> persistentClass = wireContext.getClassLoader().loadClass(this.className);
                configuration.addClass(persistentClass);
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_HCD_2", this.className);
                throw new BonitaRuntimeException(message, e);
            }
        }

        public String toString() {
            return "adding persistent class " + this.className + " to hibernate configuration";
        }
    }

    public static class AddFile
    implements Operation {
        private static final long serialVersionUID = 1L;
        String fileName;

        public AddFile(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.addFile(this.fileName);
        }

        public String toString() {
            return "adding hibernate mapping file " + this.fileName + " to configuration";
        }
    }

    public static class AddResource
    implements Operation {
        private static final long serialVersionUID = 1L;
        String resource;

        public AddResource(String resource) {
            this.resource = resource;
        }

        @Override
        public void apply(Object target, WireContext wireContext) {
            Configuration configuration = (Configuration)target;
            configuration.addResource(this.resource, wireContext.getClassLoader());
        }

        public String toString() {
            return "adding mapping resource " + this.resource + " to hibernate configuration";
        }
    }
}

