/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.descriptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.env.Descriptor;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.CollectionDescriptor;
import org.ow2.bonita.util.ExceptionManager;

public class MapDescriptor
extends CollectionDescriptor {
    private static final long serialVersionUID = 1L;
    List<Descriptor> keyDescriptors;

    public MapDescriptor() {
        super(HashMap.class.getName());
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        Map map = (Map)object;
        try {
            if (this.keyDescriptors != null) {
                for (int i = 0; i < this.keyDescriptors.size(); ++i) {
                    Descriptor keyDescriptor = this.keyDescriptors.get(i);
                    Descriptor valueDescriptor = (Descriptor)this.valueDescriptors.get(i);
                    Object key = wireContext.create(keyDescriptor, true);
                    Object value = wireContext.create(valueDescriptor, true);
                    map.put(key, value);
                }
            }
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_MD_1", this.name != null ? this.name : this.className);
            throw new WireException(message, e);
        }
    }

    public List<Descriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    public void setKeyDescriptors(List<Descriptor> keyDescriptors) {
        this.keyDescriptors = keyDescriptors;
    }
}

