/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.BonitaEnvironmentParser;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.generator.ChainerEnvEntry;
import org.ow2.bonita.env.generator.EnvEntry;
import org.ow2.bonita.env.generator.QueryApiEnvEntry;
import org.ow2.bonita.runtime.ClassDataLoader;
import org.ow2.bonita.runtime.event.MemoryLockJobExecutor;
import org.ow2.bonita.runtime.tx.StandardTransaction;
import org.ow2.bonita.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.bonita.services.impl.DbAuthentication;
import org.ow2.bonita.services.impl.DbHistory;
import org.ow2.bonita.services.impl.DbIdentity;
import org.ow2.bonita.services.impl.DbJournal;
import org.ow2.bonita.services.impl.DbPrivilegeService;
import org.ow2.bonita.services.impl.DbThreadEventService;
import org.ow2.bonita.services.impl.DbUUIDService;
import org.ow2.bonita.services.impl.DbWebService;
import org.ow2.bonita.services.impl.DbWebTokenManagementService;
import org.ow2.bonita.services.impl.DocumentManagerImpl;
import org.ow2.bonita.services.impl.DocumentStorageServiceImpl;
import org.ow2.bonita.services.impl.FileLargeDataRepository;
import org.ow2.bonita.services.impl.HibernateLobCreator;
import org.ow2.bonita.services.impl.LoggerArchiver;
import org.ow2.bonita.services.impl.LoggerRecorder;
import org.ow2.bonita.services.impl.OptimizedDbHistory;
import org.ow2.bonita.type.lob.BlobStrategyBlob;
import org.ow2.bonita.type.lob.ClobStrategyChopped;
import org.ow2.bonita.util.Misc;

public class EnvGenerator {
    private static final Logger LOG = Logger.getLogger(EnvGenerator.class.getName());
    public static final String INDENT = "  ";
    private final Map<String, EnvEntry> envFactoryEntries = new TreeMap<String, EnvEntry>();
    private final Map<String, EnvEntry> envEntries = new TreeMap<String, EnvEntry>();

    public EnvGenerator(boolean defaultConfiguration) {
        this.addApplicationEntry(this.getDomain());
        this.addApplicationEntry(this.getCoreHibernateConfiguration());
        this.addApplicationEntry(this.getCoreHibernateSessionFactory());
        this.addApplicationEntry(this.getHistoryHibernateConfiguration());
        this.addApplicationEntry(this.getHistoryHibernateSessionFactory());
        this.addApplicationEntry(this.getCommandService());
        this.addApplicationEntry(this.getVariables());
        this.addApplicationEntry(this.getEventExecutor());
        this.addApplicationEntry(this.getTypeResolver());
        this.addApplicationEntry(this.getLobCreator());
        this.addApplicationEntry(this.getBlobStrategy());
        this.addApplicationEntry(this.getClobStrategy());
        this.addApplicationEntry(this.getLargeDataRepository());
        this.addApplicationEntry(this.getDocumentationManager());
        this.addApplicationEntry(this.getDocumentStorageServiceManager());
        this.addApplicationEntry(this.getFinishedInstanceHandler());
        this.addApplicationEntry(this.getDbUUIDService());
        this.addApplicationEntry(this.getClassdataLoader());
        this.addApplicationEntry(this.getIterationDetectionPolicy());
        this.addApplicationEntry(this.getExtenstionPointsPolicy());
        this.addBlockEntry(this.getCoreHibernateSession());
        this.addBlockEntry(this.getHistoryDbSession());
        this.addBlockEntry(this.getHistoryHibernateSession());
        this.addBlockEntry(this.getCoreDbSession());
        this.addBlockEntry(this.getEventService());
        this.addBlockEntry(this.getDefaultQueryList());
        this.addBlockEntry(this.getJournalQueryList());
        this.addBlockEntry(this.getHistoryQueryList());
        this.addBlockEntry(this.getDbHistory());
        this.addBlockEntry(this.getOptimizeDbHistory());
        this.addBlockEntry(this.getRecorder());
        this.addBlockEntry(this.getArchiver());
        this.addBlockEntry(this.getTransaction());
        this.addBlockEntry(this.getJournal());
        this.addBlockEntry(this.getWebService());
        this.addBlockEntry(this.getIdentityService());
        this.addBlockEntry(this.getAuthenticationService());
        this.addBlockEntry(this.getPrivilegeService());
        this.addBlockEntry(this.getWebTokenManagementService());
    }

    private EnvEntry getOptimizeDbHistory() {
        String key = "history";
        EnvEntry optimizeDbHistoryEntry = new EnvEntry("Optimized DB history", "Optimized DB Implementation of the history. This implementation contains optimized methods. For example, a call to getUserTasks(final String userId, final ActivityState taskState)  looks in DB only if the state is an expected one in History (FINISHED is one, READY is not...)", "<history name='history' class='" + OptimizedDbHistory.class.getName() + "'>" + Misc.LINE_SEPARATOR + INDENT + "<arg><string value='" + "bonita-session:history" + "' /></arg>" + Misc.LINE_SEPARATOR + "</" + "history" + ">", true);
        return optimizeDbHistoryEntry;
    }

    private EnvEntry getHistoryDbSession() {
        return this.getDbSession("bonita-session:core", "hibernate-session:core", "hibernate session name for Bonita core.");
    }

    private EnvEntry getCoreDbSession() {
        return this.getDbSession("bonita-session:history", "hibernate-session:history", "hibernate session name for Bonita history.");
    }

    private EnvEntry getHistoryHibernateSession() {
        return this.getHibernateSession("hibernate-session:history", "hibernate-session-factory:history", "hibernate session for Bonita history.");
    }

    private EnvEntry getCoreHibernateSession() {
        return this.getHibernateSession("hibernate-session:core", "hibernate-session-factory:core", "hibernate session for Bonita core.");
    }

    private EnvEntry getHistoryHibernateSessionFactory() {
        return this.getHibernateSessionFactory("hibernate-session-factory:history", "hibernate-configuration:history", "hibernate session factory for Bonita history.");
    }

    private EnvEntry getCoreHibernateSessionFactory() {
        return this.getHibernateSessionFactory("hibernate-session-factory:core", "hibernate-configuration:core", "hibernate session factory for Bonita core.");
    }

    private EnvEntry getHistoryHibernateConfiguration() {
        StringBuilder historyPathBuilder = new StringBuilder(this.getDefaultServerFolder());
        historyPathBuilder.append(File.separator).append("conf").append(File.separator).append("bonita-history.properties");
        return this.getHibernateConfig(historyPathBuilder.toString(), "hibernate-configuration:history", "bonita.history.cache.xml", "nonstrict-read-write", "Configuration of the Hibernate session factory used by Bonita history.");
    }

    private EnvEntry getCoreHibernateConfiguration() {
        StringBuilder corePathBuilder = new StringBuilder(this.getDefaultServerFolder());
        corePathBuilder.append(File.separator).append("conf").append(File.separator).append("bonita-journal.properties");
        return this.getHibernateConfig(corePathBuilder.toString(), "hibernate-configuration:core", "bonita.core.cache.xml", "read-write", "Configuration of the Hibernate session factory used by Bonita core.");
    }

    private EnvEntry getDbHistory() {
        return new EnvEntry("Db history", "DB Implementation of the history. This implementation is full conformant with the spec (but not optimized).", "<history name='history' class='" + DbHistory.class.getName() + "'/>", false);
    }

    private EnvEntry getDefaultQueryList() {
        ArrayList<EnvEntry> queryApiEntries = new ArrayList<EnvEntry>();
        queryApiEntries.add(new EnvEntry("journal", "Reference to the journal", "<ref object='journal' />", true));
        queryApiEntries.add(new EnvEntry("history", "Reference to the history", "<ref object='history' />", true));
        return new QueryApiEnvEntry("queryList", "List of Queriers to use.", queryApiEntries, true);
    }

    private EnvEntry getJournalQueryList() {
        ArrayList<EnvEntry> queryApiEntries = new ArrayList<EnvEntry>();
        queryApiEntries.add(new EnvEntry("journal", "Reference to the journal", "<ref object='journal' />", true));
        return new QueryApiEnvEntry("journalQueryList", "List of Queriers to use.", queryApiEntries, true);
    }

    private EnvEntry getHistoryQueryList() {
        ArrayList<EnvEntry> queryApiEntries = new ArrayList<EnvEntry>();
        queryApiEntries.add(new EnvEntry("history", "Reference to the history", "<ref object='history' />", true));
        return new QueryApiEnvEntry("historyQueryList", "List of Queriers to use.", queryApiEntries, true);
    }

    private EnvEntry getRecorder() {
        ArrayList<EnvEntry> recorders = new ArrayList<EnvEntry>();
        recorders.add(new EnvEntry("Log recorder", "Recorder which writes recorded data to logs.", "<recorder class='" + LoggerRecorder.class.getName() + "' />", false));
        recorders.add(new EnvEntry("journal", "Reference to the journal", "<ref object='journal' />", true));
        return new ChainerEnvEntry("recorder", "List of recorders.", recorders, true);
    }

    private EnvEntry getArchiver() {
        ArrayList<EnvEntry> archivers = new ArrayList<EnvEntry>();
        archivers.add(new EnvEntry("Log archiver", "Archiver which writes archived data to logs.", "<archiver class='" + LoggerArchiver.class.getName() + "' />", false));
        archivers.add(new EnvEntry("history", "Reference to the history", "<ref object='history' />", true));
        return new ChainerEnvEntry("archiver", "List of archivers.", archivers, true);
    }

    private EnvEntry getDomain() {
        return EnvGenerator.getEnvEntry("domain", "Specify the domain of this environment", "<domain id='default' />", true);
    }

    private EnvEntry getTransaction() {
        return EnvGenerator.getEnvEntry("transaction", "Db Transaction.", StandardTransaction.class, true);
    }

    private EnvEntry getTypeResolver() {
        return EnvGenerator.getEnvEntry("type-resolver", "Mapping from java variable to database type", "<variable-types resource='bonita.type.resolver.xml' />", true);
    }

    private EnvEntry getLobCreator() {
        return EnvGenerator.getEnvEntry("lob-creator", "Implementation of the LobCreator interface which will be used to create SQL Blobs, Clobs.", HibernateLobCreator.class, true);
    }

    private EnvEntry getBlobStrategy() {
        return EnvGenerator.getEnvEntry("blob-strategy", "Implementation of the BlobStrategy interface which will be used to store Blobs.", BlobStrategyBlob.class, true);
    }

    private EnvEntry getClobStrategy() {
        return EnvGenerator.getEnvEntry("clob-strategy", "Implementation of the LobCreator interface which will be used to store Clobs.", ClobStrategyChopped.class, true);
    }

    private EnvEntry getEventExecutor() {
        String eventExecutorXml = "<event-executor idle-min='50' idle='10000' threads='3' lock='120000' retries='5' auto-start='true' command-service='command-service'>\n";
        eventExecutorXml = eventExecutorXml + "  <job-executor class='" + MemoryLockJobExecutor.class.getName() + "' max-parallel-jobs='50' clean-locks-at-startup='false' />\n";
        eventExecutorXml = eventExecutorXml + "  <matchers matching-condition-messages='true' without-matching-condition-messages='true' />\n";
        eventExecutorXml = eventExecutorXml + "</event-executor>\n";
        return EnvGenerator.getEnvEntry("event-executor", "Service which executes events", eventExecutorXml, true);
    }

    private EnvEntry getIterationDetectionPolicy() {
        return EnvGenerator.getEnvEntry("iteration-detection-policy", "Enable/disable iteration detection", "<iteration-detection-policy disable='false' />", true);
    }

    private EnvEntry getExtenstionPointsPolicy() {
        return EnvGenerator.getEnvEntry("extension-points", "Identify if extension points (connectors and Groovy scritps) throw the exception on failure", "<extension-points throw-exception-on-failure='false' />", true);
    }

    private EnvEntry getVariables() {
        return EnvGenerator.getEnvEntry("variables", "Properties of variables management.", "<variables store-history='true'/>", true);
    }

    private EnvEntry getCommandService() {
        String commandServiceConfigXml = "<command-service name='command-service'>\n";
        commandServiceConfigXml = commandServiceConfigXml + "  <retry-interceptor retries='5' delay='50' delay-factor='10'/>\n";
        commandServiceConfigXml = commandServiceConfigXml + "  <environment-interceptor />\n";
        commandServiceConfigXml = commandServiceConfigXml + "  <standard-transaction-interceptor />\n";
        commandServiceConfigXml = commandServiceConfigXml + "</command-service>\n";
        return EnvGenerator.getEnvEntry("command-service", "Service which executes commands", commandServiceConfigXml, true);
    }

    private EnvEntry getHibernateConfig(String propertiesName, String hibernateConfigurationName, String cacheFile, String cacheUsage, String usage) {
        StringBuffer hibernateConfigXml = new StringBuffer();
        hibernateConfigXml.append("<hibernate-configuration name='" + hibernateConfigurationName + "' >").append(Misc.LINE_SEPARATOR).append(INDENT).append("<properties file='" + propertiesName + "' />").append(Misc.LINE_SEPARATOR).append(INDENT).append("<mappings resource='bonita.mappings.hbm.xml' />").append(Misc.LINE_SEPARATOR).append(INDENT).append("<cache-configuration resource='" + cacheFile + "' usage='" + cacheUsage + "' />").append(Misc.LINE_SEPARATOR).append("</hibernate-configuration>").append(Misc.LINE_SEPARATOR);
        return EnvGenerator.getEnvEntry(hibernateConfigurationName, usage, hibernateConfigXml.toString(), true);
    }

    private EnvEntry getHibernateSessionFactory(String hibernateSessionFactoryName, String hibernateConfigurationName, String usage) {
        return EnvGenerator.getEnvEntry(hibernateSessionFactoryName, "Hibernate session factory used by " + usage + ".", "<hibernate-session-factory name='" + hibernateSessionFactoryName + "' configuration='" + hibernateConfigurationName + "' init='eager'/>", true);
    }

    private EnvEntry getHibernateSession(String hibernateSessionName, String hibernateSessionFactoryName, String usage) {
        return EnvGenerator.getEnvEntry(hibernateSessionName, "Hibernate session used by " + usage + ".", "<hibernate-session name='" + hibernateSessionName + "' factory='" + hibernateSessionFactoryName + "' />", true);
    }

    private EnvEntry getDbSession(String dbSessionName, String hibernateSessionName, String usage) {
        return EnvGenerator.getEnvEntry(dbSessionName, "Querier used in " + usage + ".", "<db-session name='" + dbSessionName + "' session='" + hibernateSessionName + "'/>", true);
    }

    private EnvEntry getFinishedInstanceHandler() {
        return EnvGenerator.getChainerEnvEntry("finished-instance-handler", "List of services called when an instance is finished.", true, ArchiveFinishedInstanceHandler.class);
    }

    private EnvEntry getJournal() {
        String key = "journal";
        String xml = "<journal name='journal' class='" + DbJournal.class.getName() + "'> " + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</journal>";
        return new EnvEntry("journal", "Implementation of the journal.", xml, true);
    }

    private EnvEntry getWebService() {
        String key = "web-service";
        String xml = "<web-service name='web-service' class='" + DbWebService.class.getName() + "'> " + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</web-service>";
        return new EnvEntry("web-service", "Implementation of the Web Service.", xml, true);
    }

    private EnvEntry getEventService() {
        String key = "event-service";
        String xml = "<event-service name='event-service' class='" + DbThreadEventService.class.getName() + "'> " + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</event-service>";
        return new EnvEntry("event-service", "Implementation of the Event Service.", xml, true);
    }

    private EnvEntry getDbUUIDService() {
        String key = "uuid-service";
        String xml = "<uuid-service name='uuid-service' class='" + DbUUIDService.class.getName() + "'/>";
        return new EnvEntry("uuid-service", "Implementation of the UUID Service.", xml, true);
    }

    private EnvEntry getClassdataLoader() {
        String key = "classdata-loader";
        String xml = "<classdata-loader name='classdata-loader' class='" + ClassDataLoader.class.getName() + "'/>";
        return new EnvEntry("classdata-loader", "Implementation of the Classdata loader Service.", xml, true);
    }

    private EnvEntry getLargeDataRepository() {
        StringBuilder fileRepositoryPath = new StringBuilder(this.getDefaultServerFolder());
        fileRepositoryPath.append(File.separator).append("work");
        String key = "large-data-repository";
        String xml = "<large-data-repository name='large-data-repository' class='" + FileLargeDataRepository.class.getName() + "'>" + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='" + fileRepositoryPath.toString() + "' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</large-data-repository>";
        return new EnvEntry("large-data-repository", "Implementation of the large data repository.", xml, true);
    }

    private EnvEntry getDocumentationManager() {
        String key = "documentation-manager";
        String i = INDENT;
        StringBuilder stb = new StringBuilder();
        stb.append("<");
        stb.append("documentation-manager");
        stb.append(" name='");
        stb.append("documentation-manager");
        stb.append("' class='");
        stb.append(DocumentManagerImpl.class.getName());
        stb.append("'>");
        stb.append(Misc.LINE_SEPARATOR);
        stb.append(INDENT);
        stb.append("<arg><string value='");
        stb.append("bonita-session:core");
        stb.append("' /></arg>");
        stb.append(Misc.LINE_SEPARATOR);
        stb.append("</");
        stb.append("documentation-manager");
        stb.append(">");
        String xml = stb.toString();
        return new EnvEntry("documentation-manager", "Implementation of the documentation manager.", xml, true);
    }

    private EnvEntry getDocumentStorageServiceManager() {
        String key = "document-storage-service";
        String i = INDENT;
        StringBuilder stb = new StringBuilder();
        stb.append("<");
        stb.append("document-storage-service");
        stb.append(" name='");
        stb.append("document-storage-service");
        stb.append("' class='");
        stb.append(DocumentStorageServiceImpl.class.getName());
        stb.append("'>");
        stb.append(Misc.LINE_SEPARATOR);
        stb.append(INDENT);
        stb.append("<arg><string value='");
        stb.append("bonita-session:core");
        stb.append("' /></arg>");
        stb.append(Misc.LINE_SEPARATOR);
        stb.append("</");
        stb.append("document-storage-service");
        stb.append(">");
        String xml = stb.toString();
        return new EnvEntry("document-storage-service", "Implementation of the document storage service.", xml, true);
    }

    private EnvEntry getIdentityService() {
        String key = "identity-service";
        String xml = "<identity-service name='identity-service' class='" + DbIdentity.class.getName() + "'>" + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</identity-service>";
        return new EnvEntry("identity-service", "Implementation of the identity service.", xml, true);
    }

    private EnvEntry getAuthenticationService() {
        String key = "authentication-service";
        String xml = "<authentication-service name='authentication-service' class='" + DbAuthentication.class.getName() + "'>" + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</authentication-service>";
        return new EnvEntry("authentication-service", "Implementation of the authentication service.", xml, true);
    }

    private EnvEntry getPrivilegeService() {
        String key = "privilege-service";
        String xml = "<privilege-service name='privilege-service' class='" + DbPrivilegeService.class.getName() + "'>" + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</privilege-service>";
        return new EnvEntry("privilege-service", "Implementation of the privilege service.", xml, true);
    }

    private EnvEntry getWebTokenManagementService() {
        String key = "web-token-service";
        String xml = "<web-token-service name='web-token-service' class='" + DbWebTokenManagementService.class.getName() + "'>" + Misc.LINE_SEPARATOR;
        xml = xml + "  <arg><string value='bonita-session:core' /></arg>" + Misc.LINE_SEPARATOR;
        xml = xml + "</web-token-service>";
        return new EnvEntry("web-token-service", "Implementation of the web token management service.", xml, true);
    }

    public String createEnvironmentXml() {
        int indentDepth = 0;
        StringBuilder result = new StringBuilder("<environment-definition>" + Misc.LINE_SEPARATOR + Misc.LINE_SEPARATOR);
        result.append(this.getIndent(++indentDepth) + "<environment-factory>" + Misc.LINE_SEPARATOR);
        ++indentDepth;
        for (EnvEntry entry : this.envFactoryEntries.values()) {
            result.append(entry.getEnvXml(this.getIndent(indentDepth))).append(Misc.LINE_SEPARATOR);
        }
        result.append(this.getIndent(--indentDepth)).append("</environment-factory>" + Misc.LINE_SEPARATOR + Misc.LINE_SEPARATOR);
        result.append(this.getIndent(indentDepth)).append("<environment>" + Misc.LINE_SEPARATOR);
        ++indentDepth;
        for (EnvEntry entry : this.envEntries.values()) {
            result.append(entry.getEnvXml(this.getIndent(indentDepth))).append(Misc.LINE_SEPARATOR);
        }
        result.append(this.getIndent(--indentDepth)).append("</environment>" + Misc.LINE_SEPARATOR + Misc.LINE_SEPARATOR);
        result.append(this.getIndent(--indentDepth)).append("</environment-definition>" + Misc.LINE_SEPARATOR);
        return result.toString();
    }

    public EnvironmentFactory createEnvironmentFactory() {
        String envConfig = this.createEnvironmentXml();
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("The following environment has been generated by: " + this.getClass().getName() + Misc.LINE_SEPARATOR + envConfig);
        }
        return BonitaEnvironmentParser.parseEnvironmentFactoryFromXmlString(envConfig);
    }

    private static String getObjectDecl(Class classToUse) {
        return "<object class='" + classToUse.getName() + "' />";
    }

    private static String getObjectDecl(String key, Class classToUse) {
        return "<object name='" + key + "' class='" + classToUse.getName() + "' />";
    }

    public static EnvEntry getEnvEntry(String name, String description, String xml, boolean enabled) {
        return new EnvEntry(name, description, xml, enabled);
    }

    public static EnvEntry getEnvEntry(String name, String description, Class<?> classToUse, boolean enabled) {
        String xml = EnvGenerator.getObjectDecl(name, classToUse);
        return new EnvEntry(name, description, xml, enabled);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.exit(1);
        }
        EnvGenerator envGenerator = null;
        try {
            Class<?> envGeneratorClass = EnvGenerator.class.getClassLoader().loadClass(args[0]);
            envGenerator = (EnvGenerator)envGeneratorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (args.length == 1) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.config(envGenerator.createEnvironmentXml());
            }
        } else {
            File file = new File(args[1]);
            File folder = file.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            file.createNewFile();
            Misc.write(envGenerator.createEnvironmentXml(), file);
        }
    }

    private String getIndent(int depth) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i <= depth; ++i) {
            buf.append(INDENT);
        }
        return buf.toString();
    }

    public static EnvEntry getChainerEnvEntry(String key, String description, boolean enable, Class<?> ... classes) {
        ArrayList<EnvEntry> chainerEntries = new ArrayList<EnvEntry>();
        for (Class<?> clazz : classes) {
            chainerEntries.add(new EnvEntry(clazz.getName(), "", EnvGenerator.getObjectDecl(clazz), true));
        }
        return new ChainerEnvEntry(key, description, chainerEntries, enable);
    }

    public final void addApplicationEntry(EnvEntry entry) {
        this.envFactoryEntries.put(entry.getName(), entry);
    }

    public final void addBlockEntry(EnvEntry entry) {
        this.envEntries.put(entry.getName(), entry);
    }

    private StringBuilder getDefaultServerFolder() {
        StringBuilder defaultServerPath = new StringBuilder("${");
        defaultServerPath.append("BONITA_HOME").append("}").append(File.separator).append("server").append(File.separator).append("default");
        return defaultServerPath;
    }
}

