/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.operation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.operation.Operation;
import org.ow2.bonita.runtime.tx.StandardResource;
import org.ow2.bonita.runtime.tx.StandardTransaction;
import org.ow2.bonita.util.ExceptionManager;

public class EnlistOperation
implements Operation {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(EnlistOperation.class.getName());
    String transactionName = null;

    @Override
    public void apply(Object target, WireContext wireContext) {
        if (!(target instanceof StandardResource)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EO_1", StandardResource.class.getName(), target, target != null ? " (" + target.getClass().getName() + ")" : "");
            throw new WireException(message);
        }
        Object object = null;
        object = this.transactionName != null ? wireContext.get(this.transactionName) : wireContext.get(Transaction.class);
        if (object == null || !(object instanceof StandardTransaction)) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_EO_2", StandardTransaction.class.getName(), this.transactionName != null ? "'" + this.transactionName + "'" : "by type", target);
            throw new WireException(message);
        }
        StandardTransaction standardTransaction = (StandardTransaction)object;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("enlisting resource " + target + " with transaction");
        }
        standardTransaction.enlistResource((StandardResource)target);
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }
}

