/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.operation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireException;
import org.ow2.bonita.env.descriptor.ArgDescriptor;
import org.ow2.bonita.env.descriptor.ObjectDescriptor;
import org.ow2.bonita.env.operation.AbstractOperation;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.ReflectUtilDescriptor;

public class InvokeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 1L;
    String methodName = null;
    List<ArgDescriptor> argDescriptors = null;

    @Override
    public void apply(Object target, WireContext wireContext) {
        try {
            Object[] args = ObjectDescriptor.getArgs(wireContext, this.argDescriptors);
            Class<?> clazz = target.getClass();
            Method method = ReflectUtilDescriptor.findMethod(clazz, this.methodName, this.argDescriptors, args);
            if (method == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_IO_1", ReflectUtilDescriptor.getSignature(this.methodName, this.argDescriptors, args));
                throw new WireException(message);
            }
            ReflectUtil.invoke(method, target, args);
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_IO_2", this.methodName, e.getMessage());
            throw new WireException(message, e);
        }
    }

    public void addArgDescriptor(ArgDescriptor argDescriptor) {
        if (this.argDescriptors == null) {
            this.argDescriptors = new ArrayList<ArgDescriptor>();
        }
        this.argDescriptors.add(argDescriptor);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public synchronized void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }
}

