/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.element.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ow2.bonita.building.XmlDefExporter;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.BusinessArchiveFactory;
import org.ow2.bonita.util.ClassDataTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.XStreamUtil;

public class BusinessArchiveImpl
implements Serializable,
BusinessArchive {
    private static final long serialVersionUID = 218650935088396315L;
    public static final String PROCESS_RESOURCE_NAME = "process-def.xml";
    protected Set<Resource> resources = new HashSet<Resource>();
    protected ProcessDefinitionUUID processUUID;

    protected BusinessArchiveImpl() {
    }

    public BusinessArchiveImpl(ProcessDefinition clientProcess, Map<String, byte[]> resources, Class<?> ... classes) throws IOException, ClassNotFoundException {
        if (clientProcess != null) {
            this.processUUID = clientProcess.getUUID();
            this.addResource(PROCESS_RESOURCE_NAME, XmlDefExporter.getInstance().createProcessDefinition(clientProcess));
        }
        HashMap<String, byte[]> allClasses = new HashMap<String, byte[]>();
        if (resources != null) {
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                String resourcePath = resource.getKey();
                if (resourcePath.endsWith(".class")) {
                    allClasses.put(resource.getKey(), resource.getValue());
                    continue;
                }
                this.addResource(resource.getKey(), resource.getValue());
            }
        }
        if (classes != null && classes.length > 0) {
            for (Class<?> clazz : classes) {
                if (clazz == null) continue;
                allClasses.put(clazz.getName().replace(".", "/") + ".class", ClassDataTool.getClassData(clazz));
            }
        }
        if (!allClasses.isEmpty()) {
            byte[] jar = Misc.generateJar(allClasses);
            this.addResource("bonita-generated.jar", jar);
        }
    }

    public BusinessArchiveImpl(ProcessDefinitionUUID processUUID, Map<String, byte[]> resources) {
        this.processUUID = processUUID;
        if (resources != null) {
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                this.addResource(resource.getKey(), resource.getValue());
            }
        }
    }

    @Override
    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        byte[] processBytes = this.getResource(PROCESS_RESOURCE_NAME);
        if (processBytes == null) {
            return null;
        }
        File xmlDefFile = null;
        try {
            File tempDir = Misc.createDirectories(BonitaConstants.getTemporaryFolder());
            xmlDefFile = Misc.createTempFile("xmlDef", null, tempDir);
            Misc.getFile(xmlDefFile, processBytes);
            Properties contextProperties = BusinessArchiveFactory.createPropertiesFromResources(this.getResources());
            ProcessDefinition processDefinition = ProcessBuilder.createProcessFromXmlDefFile(xmlDefFile.toURL(), contextProperties);
            return processDefinition;
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
        finally {
            if (xmlDefFile != null) {
                xmlDefFile.delete();
            }
        }
    }

    @Override
    public Map<String, byte[]> getJarFiles() {
        return this.getResources(".*\\.jar");
    }

    @Override
    public byte[] getResource(String resourcePath) {
        for (Resource resource : this.resources) {
            if (!resource.getPath().equals(resourcePath)) continue;
            return resource.getData();
        }
        return null;
    }

    @Override
    public Map<String, byte[]> getResources(String regex) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Resource resource : this.resources) {
            if (!resource.getPath().matches(regex)) continue;
            result.put(resource.getPath(), resource.getData());
        }
        return result;
    }

    @Override
    public Map<String, byte[]> getOtherResources(String regex) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Resource resource : this.resources) {
            if (resource.getPath().matches(regex)) continue;
            result.put(resource.getPath(), resource.getData());
        }
        return result;
    }

    public void addResource(String resourcePath, byte[] resourceData) {
        Misc.checkArgsNotNull(resourcePath, resourceData);
        this.resources.add(new Resource(resourcePath, resourceData));
    }

    @Override
    public Map<String, byte[]> getResources() {
        HashMap<String, byte[]> allResources = new HashMap<String, byte[]>();
        for (Resource resource : this.resources) {
            allResources.put(resource.getPath(), resource.getData());
        }
        return allResources;
    }

    public String toString() {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML((Object)this);
    }

    protected static class Resource
    implements Serializable {
        private static final long serialVersionUID = 4985009903197019706L;
        protected String path;
        protected byte[] data;

        protected Resource() {
        }

        public Resource(String path, byte[] data) {
            this.path = path;
            this.data = data;
        }

        public String getPath() {
            return this.path;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

