/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.majorElement.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.impl.AttachmentDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.EventProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.EventProcessDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ParticipantDefinitionImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.Misc;

public class ProcessDefinitionImpl
extends LightProcessDefinitionImpl
implements ProcessDefinition {
    private static final long serialVersionUID = -572795239631090498L;
    protected Set<DataFieldDefinition> dataFields;
    protected Set<ParticipantDefinition> participants;
    protected Set<ActivityDefinition> activities;
    protected Set<AttachmentDefinition> attachments;
    protected Set<String> subProcesses;
    protected List<EventProcessDefinition> eventSubProcesses;
    protected Map<String, String> metadata;
    protected List<HookDefinition> connectors;
    protected Set<IterationDescriptor> iterationDescriptors;

    protected ProcessDefinitionImpl() {
    }

    public ProcessDefinitionImpl(String name, String version) {
        super(name, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinitionImpl(ProcessDefinition src) {
        super(src);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Set<ActivityDefinition> activities;
            Set<ParticipantDefinition> participants;
            List<HookDefinition> connectors;
            ProcessDefinitionImpl srcImpl = (ProcessDefinitionImpl)src;
            Thread.currentThread().setContextClassLoader(srcImpl.getClassLoader(src.getUUID()));
            Set<DataFieldDefinition> dataFields = src.getDataFields();
            if (dataFields != null) {
                this.dataFields = new HashSet<DataFieldDefinition>();
                for (DataFieldDefinition d : dataFields) {
                    this.dataFields.add(new DataFieldDefinitionImpl(d));
                }
            }
            if ((connectors = src.getConnectors()) != null) {
                this.connectors = new ArrayList<HookDefinition>();
                for (HookDefinition d : connectors) {
                    this.connectors.add(new ConnectorDefinitionImpl(d));
                }
            }
            if ((participants = src.getParticipants()) != null) {
                this.participants = new HashSet<ParticipantDefinition>();
                for (ParticipantDefinition d : participants) {
                    this.participants.add(new ParticipantDefinitionImpl(d));
                }
            }
            if ((activities = src.getActivities()) != null) {
                this.activities = new HashSet<ActivityDefinition>();
                for (ActivityDefinition d : activities) {
                    this.activities.add(new ActivityDefinitionImpl(d));
                }
            }
            this.metadata = new HashMap<String, String>();
            Map<String, String> meta = src.getMetaData();
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                this.metadata.put(entry.getKey(), entry.getValue());
            }
            Map<String, AttachmentDefinition> other = src.getAttachments();
            if (!other.isEmpty()) {
                this.attachments = new HashSet<AttachmentDefinition>();
                for (AttachmentDefinition attach : other.values()) {
                    this.attachments.add(new AttachmentDefinitionImpl(attach));
                }
            }
            if (src.getIterationDescriptors() != null) {
                this.iterationDescriptors = new HashSet<IterationDescriptor>();
                for (IterationDescriptor id : src.getIterationDescriptors()) {
                    this.iterationDescriptors.add(new IterationDescriptor(id));
                }
            }
            List<EventProcessDefinition> eventSubProcesses = src.getEventSubProcesses();
            this.eventSubProcesses = new ArrayList<EventProcessDefinition>();
            for (EventProcessDefinition d : eventSubProcesses) {
                this.eventSubProcesses.add(new EventProcessDefinitionImpl(d));
            }
            this.subProcesses = CopyTool.copy(src.getSubProcesses());
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    protected ClassLoader getClassLoader(ProcessDefinitionUUID processUUID) {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public String toString() {
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", name:" + this.getName() + ", description:" + this.getDescription() + ", version:" + this.getVersion();
        st = st + "]";
        return st;
    }

    @Override
    public Set<String> getClassDependencies() {
        HashSet<String> classDependencies = new HashSet<String>();
        for (ParticipantDefinition participant : this.getParticipants()) {
            if (participant.getRoleMapper() == null) continue;
            classDependencies.add(participant.getRoleMapper().getClassName());
        }
        for (HookDefinition connector : this.getConnectors()) {
            classDependencies.add(connector.getClassName());
        }
        for (ActivityDefinition activity : this.getActivities()) {
            classDependencies.addAll(activity.getClassDependencies());
        }
        return classDependencies;
    }

    @Override
    public Set<String> getProcessDependencies() {
        HashSet<String> processDependencies = new HashSet<String>();
        for (ActivityDefinition activity : this.getActivities()) {
            if (activity.getSubflowProcessName() == null) continue;
            processDependencies.add(activity.getSubflowProcessName());
        }
        return processDependencies;
    }

    @Override
    public Set<DataFieldDefinition> getDataFields() {
        if (this.dataFields == null) {
            return Collections.emptySet();
        }
        return this.dataFields;
    }

    @Override
    public Set<String> getSubProcesses() {
        if (this.subProcesses == null) {
            return Collections.emptySet();
        }
        return this.subProcesses;
    }

    public void setSubProcesses(Set<String> subProcesses) {
        this.subProcesses = subProcesses;
    }

    @Override
    public Set<ParticipantDefinition> getParticipants() {
        if (this.participants == null) {
            return Collections.emptySet();
        }
        return this.participants;
    }

    @Override
    public Set<ActivityDefinition> getActivities() {
        if (this.activities == null) {
            return Collections.emptySet();
        }
        return this.activities;
    }

    @Override
    public Set<TransitionDefinition> getTransitions() {
        if (this.activities == null) {
            return Collections.emptySet();
        }
        HashSet<TransitionDefinition> transitions = new HashSet<TransitionDefinition>();
        for (ActivityDefinition activity : this.getActivities()) {
            Set<TransitionDefinition> activityTransitions = activity.getOutgoingTransitions();
            for (TransitionDefinition transition : activityTransitions) {
                transitions.add(transition);
            }
        }
        return transitions;
    }

    @Override
    public Map<String, String> getMetaData() {
        if (this.metadata == null) {
            return Collections.emptyMap();
        }
        return this.metadata;
    }

    @Override
    public String getAMetaData(String key) {
        Misc.checkArgsNotNull(key);
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    @Override
    public List<HookDefinition> getConnectors() {
        if (this.connectors == null) {
            return Collections.emptyList();
        }
        return this.connectors;
    }

    public void setState(ProcessDefinition.ProcessState state) {
        this.state = state;
    }

    public void setType(LightProcessDefinition.ProcessType type) {
        this.type = type;
    }

    public void setUndeployedDate(Date undeployedDate) {
        this.undeployedDate = Misc.getTime(undeployedDate);
    }

    public void setUndeployedBy(String undeployedBy) {
        this.undeployedBy = undeployedBy;
    }

    public void addData(DataFieldDefinition data) {
        if (this.dataFields == null) {
            this.dataFields = new HashSet<DataFieldDefinition>();
        }
        this.dataFields.add(data);
    }

    public void addGroup(ParticipantDefinitionImpl group) {
        if (this.participants == null) {
            this.participants = new HashSet<ParticipantDefinition>();
        }
        this.participants.add(group);
    }

    public void addActivity(ActivityDefinition activity) {
        if (this.activities == null) {
            this.activities = new HashSet<ActivityDefinition>();
        }
        this.activities.add(activity);
    }

    public void setDeployedDate(Date deployedDate) {
        this.deployedDate = Misc.getTime(deployedDate);
    }

    public void setDeployedBy(String deployedBy) {
        this.deployedBy = deployedBy;
    }

    public void deleteAMetaData(String key) {
        Misc.checkArgsNotNull(key);
        this.metadata.remove(key);
    }

    public void addAMetaData(String key, String value) {
        Misc.checkArgsNotNull(key, value);
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, value);
    }

    public void addAttachment(AttachmentDefinition attach) {
        Misc.checkArgsNotNull(attach);
        if (this.attachments == null) {
            this.attachments = new HashSet<AttachmentDefinition>();
        }
        this.attachments.add(attach);
    }

    public void addConnector(HookDefinition connector) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<HookDefinition>();
        }
        this.connectors.add(connector);
    }

    @Override
    public ActivityDefinition getActivity(String name) {
        for (ActivityDefinition activity : this.getActivities()) {
            if (!activity.getName().equals(name)) continue;
            return activity;
        }
        return null;
    }

    @Override
    public DataFieldDefinition getDatafield(String name) {
        for (DataFieldDefinition datafield : this.getDataFields()) {
            if (!datafield.getName().equals(name)) continue;
            return datafield;
        }
        return null;
    }

    @Override
    public AttachmentDefinition getAttachment(String name) {
        return this.getAttachments().get(name);
    }

    @Override
    public Map<String, AttachmentDefinition> getAttachments() {
        if (this.attachments == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AttachmentDefinition> result = new HashMap<String, AttachmentDefinition>();
        for (AttachmentDefinition attach : this.attachments) {
            result.put(attach.getName(), attach);
        }
        return result;
    }

    @Override
    public Map<String, ActivityDefinition> getFinalActivities() {
        HashMap<String, ActivityDefinition> result = new HashMap<String, ActivityDefinition>();
        for (ActivityDefinition activity : this.getActivities()) {
            if (activity.hasOutgoingTransitions()) continue;
            result.put(activity.getName(), activity);
        }
        return result;
    }

    @Override
    public Map<String, ActivityDefinition> getInitialActivities() {
        HashMap<String, ActivityDefinition> result = new HashMap<String, ActivityDefinition>();
        for (ActivityDefinition activity : this.getActivities()) {
            if (activity.hasIncomingTransitions()) continue;
            result.put(activity.getName(), activity);
        }
        return result;
    }

    @Override
    public Set<IterationDescriptor> getIterationDescriptors() {
        if (this.iterationDescriptors == null) {
            return Collections.emptySet();
        }
        return this.iterationDescriptors;
    }

    public void addIterationDescriptors(IterationDescriptor iterationDescriptor) {
        if (this.iterationDescriptors == null) {
            this.iterationDescriptors = new HashSet<IterationDescriptor>();
        }
        this.iterationDescriptors.add(iterationDescriptor);
    }

    public boolean containsIterationDescriptor(IterationDescriptor itDesc) {
        for (IterationDescriptor id : this.getIterationDescriptors()) {
            if (!id.equals(itDesc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<IterationDescriptor> getIterationDescriptors(String activityName) {
        HashSet<IterationDescriptor> result = new HashSet<IterationDescriptor>();
        for (IterationDescriptor id : this.getIterationDescriptors()) {
            if (!id.containsNode(activityName)) continue;
            result.add(id);
        }
        return result;
    }

    public void addCategory(String categoryName) {
        if (categoryName != null && categoryName.trim().length() > 0) {
            if (this.categories == null) {
                this.categories = new HashSet();
            }
            this.categories.add(categoryName);
        }
    }

    public void setCategories(Set<String> categoryNames) {
        this.categories = categoryNames;
    }

    public void addEventSubProcess(EventProcessDefinition eventProcess) {
        if (this.eventSubProcesses == null) {
            this.eventSubProcesses = new ArrayList<EventProcessDefinition>();
        }
        this.eventSubProcesses.add(eventProcess);
    }

    @Override
    public List<EventProcessDefinition> getEventSubProcesses() {
        if (this.eventSubProcesses == null) {
            return Collections.emptyList();
        }
        return this.eventSubProcesses;
    }
}

