/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class TaskNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -3138973316075795539L;
    private final ActivityInstanceUUID taskUUID;

    public TaskNotFoundException(String id, ActivityInstanceUUID taskUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("TNFE1", taskUUID));
        this.taskUUID = taskUUID;
    }

    public TaskNotFoundException(TaskNotFoundException e) {
        super(e.getMessage());
        this.taskUUID = e.getActivityInstanceUUID();
    }

    public static TaskNotFoundException build(String id, Throwable e) {
        if (!(e instanceof TaskNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("TNFE2", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new TaskNotFoundException((TaskNotFoundException)e);
    }

    public ActivityInstanceUUID getActivityInstanceUUID() {
        return this.taskUUID;
    }
}

