/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class VariableNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -5432738295806093855L;
    private ProcessInstanceUUID instanceUUID;
    private String activityId;
    private String variableId;
    private ActivityInstanceUUID activityUUID;

    public VariableNotFoundException(String id, ProcessInstanceUUID instanceUUID, String activityId, String variableId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("VNFE1", variableId, activityId, instanceUUID));
        this.instanceUUID = instanceUUID;
        this.activityId = activityId;
        this.variableId = variableId;
    }

    public VariableNotFoundException(String id, ProcessInstanceUUID instanceUUID, String variableId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("VNFE2", variableId, instanceUUID));
        this.instanceUUID = instanceUUID;
        this.activityId = null;
        this.variableId = variableId;
    }

    public VariableNotFoundException(VariableNotFoundException e) {
        super(e.getMessage());
        this.instanceUUID = e.getInstanceUUID();
        this.activityId = e.getActivityId();
        this.variableId = e.getVariableId();
    }

    public VariableNotFoundException(String id, ActivityInstanceUUID activityUUID, String variableId) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("VNFE3", variableId, activityUUID));
        this.variableId = variableId;
        this.activityUUID = activityUUID;
    }

    public static VariableNotFoundException build(String id, Throwable e) {
        if (!(e instanceof VariableNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("VNFE4", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new VariableNotFoundException((VariableNotFoundException)e);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public ProcessInstanceUUID getInstanceUUID() {
        return this.instanceUUID;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }
}

