/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.exception.CategoryAlreadyExistsException;
import org.ow2.bonita.facade.exception.CategoryNotFoundException;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.AbstractRemoteWebAPI;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.runtime.Label;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.LightProcessInstance;

public class AbstractRemoteWebAPIImpl
implements AbstractRemoteWebAPI {
    protected Map<String, WebAPI> apis = new HashMap<String, WebAPI>();

    protected WebAPI getAPI(Map<String, String> options) {
        if (options == null) {
            throw new IllegalArgumentException("The options are null or not well set.");
        }
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.apis.put(queryList, new StandardAPIAccessorImpl().getWebAPI(queryList));
        }
        return this.apis.get(queryList);
    }

    @Override
    public void deletePhantomCases(Map<String, String> options) throws RemoteException {
        this.getAPI(options).deletePhantomCases();
    }

    @Override
    public void addCasesToLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addCasesToLabel(ownerName, labelName, caseList);
    }

    @Override
    public void addLabel(String labelName, String ownerName, String editableCSSStyleName, String readonlyCSSStyleName, String previewCSSStyleName, boolean isVisible, boolean hasToBeDisplayed, String iconCSSStyle, Set<ProcessInstanceUUID> caseList, int displayOrder, boolean isSystemLabel, Map<String, String> options) throws RemoteException {
        this.getAPI(options).addLabel(labelName, ownerName, editableCSSStyleName, readonlyCSSStyleName, previewCSSStyleName, isVisible, hasToBeDisplayed, iconCSSStyle, caseList, displayOrder, isSystemLabel);
    }

    @Override
    public Label getLabel(String ownerName, String labelName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLabel(ownerName, labelName);
    }

    @Override
    public Set<Label> getLabels(String ownerName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLabels(ownerName);
    }

    @Override
    public List<Label> getSystemLabels(String ownerName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getSystemLabels(ownerName);
    }

    @Override
    public List<Label> getUserCustomLabels(String ownerName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getUserCustomLabels(ownerName);
    }

    @Override
    public Set<Category> getAllCategories(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllCategories();
    }

    @Override
    public Set<Category> getAllCategoriesByUUIDExcept(Set<CategoryUUID> uuids, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllCategoriesByUUIDExcept(uuids);
    }

    @Override
    public Set<Category> getCategories(Set<String> names, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getCategories(names);
    }

    @Override
    public Set<Category> getCategoriesByUUIDs(Set<CategoryUUID> uuids, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getCategoriesByUUIDs(uuids);
    }

    @Override
    public void deleteCategories(Set<String> categoryNames, Map<String, String> options) throws RemoteException {
        this.getAPI(options).deleteCategories(categoryNames);
    }

    @Override
    public void deleteCategoriesByUUIDs(Set<CategoryUUID> uuids, Map<String, String> options) throws RemoteException {
        this.getAPI(options).deleteCategoriesByUUIDs(uuids);
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(String ownerName, Set<String> labelNames, int startingIndex, int maxElementCount, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcessInstances(ownerName, labelNames, startingIndex, maxElementCount);
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> labels, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getCases(ownerName, labels);
    }

    @Override
    public void removeCasesFromLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList, Map<String, String> options) throws RemoteException {
        this.getAPI(options).removeCasesFromLabel(ownerName, labelName, caseList);
    }

    @Override
    public void removeLabel(String ownerName, String labelName, Map<String, String> options) throws RemoteException {
        this.getAPI(options).removeLabel(ownerName, labelName);
    }

    @Override
    public void updateLabelCSS(String ownerName, String labelName, String aEditableCSSStyle, String aPreviewCSSStyle, String aReadOnlyCSSStyle, Map<String, String> options) throws RemoteException {
        this.getAPI(options).updateLabelCSS(ownerName, labelName, aEditableCSSStyle, aPreviewCSSStyle, aReadOnlyCSSStyle);
    }

    @Override
    public void updateLabelName(String ownerName, String labelName, String newName, Map<String, String> options) throws RemoteException {
        this.getAPI(options).updateLabelName(ownerName, labelName, newName);
    }

    @Override
    public Set<Label> getCaseLabels(String ownerName, ProcessInstanceUUID case_, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getCaseLabels(ownerName, case_);
    }

    @Override
    public Map<ProcessInstanceUUID, Set<Label>> getCasesLabels(String ownerName, Set<ProcessInstanceUUID> cases, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getCasesLabels(ownerName, cases);
    }

    @Override
    public void removeAllCasesFromLabels(Set<ProcessInstanceUUID> caseList, Map<String, String> options) throws RemoteException {
        this.getAPI(options).removeAllCasesFromLabels(caseList);
    }

    @Override
    public Set<Label> getLabels(String ownerName, Set<String> labelsName, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLabels(ownerName, labelsName);
    }

    @Override
    public void deleteAllCases(Map<String, String> options) throws RemoteException {
        this.getAPI(options).deleteAllCases();
    }

    @Override
    public void updateLabelVisibility(String ownerName, String labelName, boolean isVisible, Map<String, String> options) throws RemoteException {
        this.getAPI(options).updateLabelVisibility(ownerName, labelName, isVisible);
    }

    @Override
    public void updateLabelVisibility(String ownerName, Map<String, Boolean> labelvisibilities, Map<String, String> options) throws RemoteException {
        this.getAPI(options).updateLabelVisibility(ownerName, labelvisibilities);
    }

    @Override
    public String generateTemporaryToken(String identityKey, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).generateTemporaryToken(identityKey);
    }

    @Override
    public String getIdentityKeyFromTemporaryToken(String token, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getIdentityKeyFromTemporaryToken(token);
    }

    @Override
    public void removeAllLabelsExcept(Set<String> labelNames, Map<String, String> options) throws RemoteException {
        this.getAPI(options).removeAllLabelsExcept(labelNames);
    }

    @Override
    public void removeLabels(Set<String> labelNames, Map<String, String> options) throws RemoteException {
        this.getAPI(options).removeLabels(labelNames);
    }

    @Override
    public void executeConnectorAndSetVariables(String connectorClassName, Map<String, Object[]> parameters, ActivityInstance activityInstance, Map<String, Object> context, Map<String, String> options) throws RemoteException, Exception {
        this.getAPI(options).executeConnectorAndSetVariables(connectorClassName, parameters, activityInstance, context);
    }

    @Override
    public Map<String, Object> executeConnectorAndGetVariablesToSet(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context, Map<String, String> options) throws RemoteException, Exception {
        return this.getAPI(options).executeConnectorAndGetVariablesToSet(connectorClassName, parameters, processDefinitionUUID, context);
    }

    @Override
    public LightProcessDefinition setProcessCategories(ProcessDefinitionUUID processUUID, Set<String> categoryNames, Map<String, String> options) throws RemoteException, ProcessNotFoundException {
        return this.getAPI(options).setProcessCategories(processUUID, categoryNames);
    }

    @Override
    public void addCategory(String name, String iconCSSStyle, String previewCSSStyleName, String cssStyleName, Map<String, String> options) throws RemoteException, CategoryAlreadyExistsException {
        this.getAPI(options).addCategory(name, iconCSSStyle, previewCSSStyleName, cssStyleName);
    }

    @Override
    public Category updateCategoryByUUID(String value, String name, String iconCSSStyle, String previewCSSStyleName, String cssStyleName, Map<String, String> options) throws RemoteException, CategoryNotFoundException, CategoryAlreadyExistsException {
        return this.getAPI(options).updateCategoryByUUID(value, name, iconCSSStyle, previewCSSStyleName, cssStyleName);
    }

    @Override
    public Document addProcessDocumentTemplate(String name, ProcessDefinitionUUID processDefinitionUUID, String fileName, String mimeType, byte[] content, Map<String, String> options) throws RemoteException, ProcessNotFoundException, DocumentAlreadyExistsException, DocumentationCreationException {
        return this.getAPI(options).addProcessDocumentTemplate(name, processDefinitionUUID, fileName, mimeType, content);
    }

    @Override
    public List<Document> getProcessDocumentTemplates(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws RemoteException, ProcessNotFoundException, DocumentationCreationException {
        return this.getAPI(options).getProcessDocumentTemplates(processDefinitionUUID);
    }
}

