/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.CommandAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.RemoteCommandAPI;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.Command;

public class RemoteCommandAPIImpl
implements RemoteCommandAPI {
    protected Map<String, CommandAPI> apis = new HashMap<String, CommandAPI>();

    protected CommandAPI getAPI(Map<String, String> options) {
        if (options == null) {
            throw new IllegalArgumentException("The options are null or not well set.");
        }
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.putAPI(queryList);
        }
        return this.apis.get(queryList);
    }

    protected void putAPI(String queryList) {
        this.apis.put(queryList, new StandardAPIAccessorImpl().getCommandAPI(queryList));
    }

    @Override
    public <T> T execute(Command<T> command, Map<String, String> options) throws Exception {
        return this.getAPI(options).execute(command);
    }

    @Override
    public <T> T execute(Command<T> command, ProcessDefinitionUUID processUUID, Map<String, String> options) throws Exception {
        return this.getAPI(options).execute(command, processUUID);
    }
}

