/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ParticipantNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.RemoteQueryDefinitionAPI;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ParticipantDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.light.LightProcessDefinition;

public class RemoteQueryDefinitionAPIImpl
implements RemoteQueryDefinitionAPI {
    protected Map<String, QueryDefinitionAPI> apis = new HashMap<String, QueryDefinitionAPI>();

    protected QueryDefinitionAPI getAPI(Map<String, String> options) {
        if (options == null) {
            throw new IllegalArgumentException("The options are null or not well set.");
        }
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.apis.put(queryList, new StandardAPIAccessorImpl().getQueryDefinitionAPI(queryList));
        }
        return this.apis.get(queryList);
    }

    @Override
    public int getNumberOfProcesses(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfProcesses();
    }

    @Override
    public ProcessDefinition getProcess(String processId, String version, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcess(processId, version);
    }

    @Override
    public ProcessDefinition getLastProcess(String processId, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getLastProcess(processId);
    }

    @Override
    public LightProcessDefinition getLastLightProcess(String processId, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getLastLightProcess(processId);
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcesses(fromIndex, pageSize);
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcesses(fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public BusinessArchive getBusinessArchive(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getBusinessArchive(processDefinitionUUID);
    }

    @Override
    public ProcessDefinition getProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcess(processDefinitionUUID);
    }

    @Override
    public List<ProcessDefinition> getProcesses(int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcesses(fromIndex, pageSize);
    }

    @Override
    public Set<ActivityDefinition> getProcessActivities(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessActivities(processDefinitionUUID);
    }

    @Override
    public ActivityDefinition getProcessActivity(ProcessDefinitionUUID processDefinitionUUID, String activityId, Map<String, String> options) throws ProcessNotFoundException, ActivityNotFoundException, RemoteException {
        return this.getAPI(options).getProcessActivity(processDefinitionUUID, activityId);
    }

    @Override
    public ActivityDefinitionUUID getProcessActivityId(ProcessDefinitionUUID processDefinitionUUID, String activityName, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessActivityId(processDefinitionUUID, activityName);
    }

    @Override
    public ParticipantDefinition getProcessParticipant(ProcessDefinitionUUID processDefinitionUUID, String participantId, Map<String, String> options) throws ProcessNotFoundException, ParticipantNotFoundException, RemoteException {
        return this.getAPI(options).getProcessParticipant(processDefinitionUUID, participantId);
    }

    @Override
    public ParticipantDefinitionUUID getProcessParticipantId(ProcessDefinitionUUID processDefinitionUUID, String participantName, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessParticipantId(processDefinitionUUID, participantName);
    }

    @Override
    public Set<ParticipantDefinition> getProcessParticipants(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessParticipants(processDefinitionUUID);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcesses();
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcesses(processId);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(ProcessDefinition.ProcessState processState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcesses(processState);
    }

    @Override
    public Set<ProcessDefinition> getProcesses(String processId, ProcessDefinition.ProcessState processState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcesses(processId, processState);
    }

    @Override
    public DataFieldDefinition getProcessDataField(ProcessDefinitionUUID processDefinitionUUID, String dataFieldId, Map<String, String> options) throws ProcessNotFoundException, DataFieldNotFoundException, RemoteException {
        return this.getAPI(options).getProcessDataField(processDefinitionUUID, dataFieldId);
    }

    @Override
    public Set<DataFieldDefinition> getProcessDataFields(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessDataFields(processDefinitionUUID);
    }

    @Override
    public Set<DataFieldDefinition> getActivityDataFields(ActivityDefinitionUUID activityDefinitionUUID, Map<String, String> options) throws ActivityDefNotFoundException, RemoteException {
        return this.getAPI(options).getActivityDataFields(activityDefinitionUUID);
    }

    @Override
    public DataFieldDefinition getActivityDataField(ActivityDefinitionUUID activityDefinitionUUID, String dataFieldId, Map<String, String> options) throws ActivityDefNotFoundException, DataFieldNotFoundException, RemoteException {
        return this.getAPI(options).getActivityDataField(activityDefinitionUUID, dataFieldId);
    }

    @Override
    public String getProcessMetaData(ProcessDefinitionUUID uuid, String key, Map<String, String> options) throws RemoteException, ProcessNotFoundException {
        return this.getAPI(options).getProcessMetaData(uuid, key);
    }

    @Override
    public InitialAttachment getProcessAttachment(ProcessDefinitionUUID processUUID, String attachmentName, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessAttachment(processUUID, attachmentName);
    }

    @Override
    public Set<InitialAttachment> getProcessAttachments(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessAttachments(processUUID);
    }

    @Override
    public AttachmentDefinition getAttachmentDefinition(ProcessDefinitionUUID processUUID, String attachmentName, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getAttachmentDefinition(processUUID, attachmentName);
    }

    @Override
    public Set<AttachmentDefinition> getAttachmentDefinitions(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getAttachmentDefinitions(processUUID);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(ProcessDefinition.ProcessState processState, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcesses(processState);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getLightProcesses();
    }

    @Override
    public LightProcessDefinition getLightProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, String> options) throws RemoteException, ProcessNotFoundException {
        return this.getAPI(options).getLightProcess(processDefinitionUUID);
    }

    @Override
    public byte[] getResource(ProcessDefinitionUUID definitionUUID, String resourcePath, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getResource(definitionUUID, resourcePath);
    }

    @Override
    public Set<LightProcessDefinition> getLightProcesses(Set<ProcessDefinitionUUID> processUUIDs, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getLightProcesses(processUUIDs);
    }

    @Override
    public List<LightProcessDefinition> getLightProcesses(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getLightProcesses(processUUIDs, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public List<LightProcessDefinition> getAllLightProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllLightProcessesExcept(processUUIDs, fromIndex, pageSize);
    }

    @Override
    public List<LightProcessDefinition> getAllLightProcessesExcept(Set<ProcessDefinitionUUID> processUUIDs, int fromIndex, int pageSize, ProcessDefinitionCriterion pagingCriterion, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getAllLightProcessesExcept(processUUIDs, fromIndex, pageSize, pagingCriterion);
    }

    @Override
    public Set<ProcessDefinitionUUID> getProcessUUIDs(String category, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcessUUIDs(category);
    }

    @Override
    public Set<ActivityDefinitionUUID> getProcessTaskUUIDs(ProcessDefinitionUUID processsUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getProcessTaskUUIDs(processsUUID);
    }

    @Override
    public Date getMigrationDate(ProcessDefinitionUUID processUUID, Map<String, String> options) throws ProcessNotFoundException, RemoteException {
        return this.getAPI(options).getMigrationDate(processUUID);
    }
}

