/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.Context;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.facade.rest.interceptor.RESTBonitaRuntimeExceptionWrapper;
import org.ow2.bonita.facade.rest.wrapper.RESTSet;
import org.ow2.bonita.identity.auth.APIMethodsSecurity;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.ExceptionManager;

public class ClientRemoteAPIInterceptor
implements InvocationHandler {
    private final Object api;
    private final String queryList;

    public ClientRemoteAPIInterceptor(Object api, String queryList) {
        this.api = api;
        this.queryList = queryList;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("queryList", this.queryList);
        if (!APIMethodsSecurity.isSecuredMethod(method)) {
            options.put("user", null);
        } else {
            options.put("user", UserOwner.getUser());
        }
        options.put("domain", DomainOwner.getDomain());
        if (this.isREST() && APIMethodsSecurity.isSecuredMethod(method)) {
            options.put("restUser", RESTUserOwner.getUser());
            options.put("passwordHash", PasswordOwner.getPassword());
        }
        try {
            Object[] methodsArgs;
            int i;
            Class[] params;
            Class<?>[] p = method.getParameterTypes();
            if (p.length > 0) {
                params = new Class[p.length + 1];
                for (i = 0; i < p.length; ++i) {
                    params[i] = p[i];
                }
                params[p.length] = Map.class;
            } else {
                params = new Class[]{Map.class};
            }
            if (args != null) {
                methodsArgs = new Object[args.length + 1];
                for (i = 0; i < args.length; ++i) {
                    methodsArgs[i] = args[i];
                }
                methodsArgs[args.length] = options;
            } else {
                methodsArgs = new Object[]{options};
            }
            if (this.isREST()) {
                i = 0;
                Type[] genericParams = method.getGenericParameterTypes();
                for (Class<?> currentClass : method.getParameterTypes()) {
                    Type type;
                    if (currentClass.equals(Collection.class)) {
                        params[i] = List.class;
                        methodsArgs[i] = this.getList((Collection)methodsArgs[i]);
                    } else if (currentClass.equals(Set.class) && genericParams[i] instanceof ParameterizedType && !((type = ((ParameterizedType)genericParams[i]).getActualTypeArguments()[0]) instanceof Class)) {
                        params[i] = RESTSet.class;
                        methodsArgs[i] = new RESTSet((Set)methodsArgs[i]);
                    }
                    ++i;
                }
            }
            String methodName = method.getName();
            if (this.isREST()) {
                if (methodName.equals("createDocument") && methodsArgs.length == 6 && methodsArgs[4] != null) {
                    methodName = "createDocumentOctetStream";
                } else if (methodName.equals("addDocumentVersion") && methodsArgs.length == 6 && methodsArgs[4] != null) {
                    methodName = "addDocumentVersionOctetStream";
                } else if (methodName.equals("addAttachment") && methodsArgs.length == 5 && methodsArgs[3] != null) {
                    methodName = "addAttachmentOctetStream";
                }
            }
            Method m = this.api.getClass().getMethod(methodName, params);
            return m.invoke(this.api, methodsArgs);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable invocationExceptionCause = e.getCause();
                if (invocationExceptionCause instanceof RemoteException) {
                    RemoteException remoteException = (RemoteException)invocationExceptionCause;
                    Throwable remoteCause = this.getRemoteCause(remoteException);
                    InterceptorUtil.manageInvokeExceptionCause(method, remoteCause);
                } else {
                    if (invocationExceptionCause instanceof RESTBonitaRuntimeExceptionWrapper) {
                        RESTBonitaRuntimeExceptionWrapper exception = (RESTBonitaRuntimeExceptionWrapper)invocationExceptionCause;
                        throw exception.getCause();
                    }
                    throw invocationExceptionCause;
                }
            }
            String message = ExceptionManager.getInstance().getFullMessage("baa_CAPII_1", e);
            throw new BonitaInternalException(message, e);
        }
    }

    private boolean isREST() {
        String apiType = System.getProperty("org.ow2.bonita.api-type");
        return apiType != null && apiType.equalsIgnoreCase(Context.REST.toString());
    }

    private <T> List<T> getList(Collection<T> col) {
        if (col == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(col);
    }

    private Throwable getRemoteCause(RemoteException e) {
        Throwable t = e;
        while (t instanceof RemoteException) {
            t = ((Throwable)t).getCause();
        }
        return t;
    }
}

