/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class EJB3Interceptor {
    private static final int SUFFIX_LENGTH = "Bean".length();

    private Object getStandaloneAPI(String className, String queryList) {
        try {
            StandardAPIAccessorImpl apiAccessor = new StandardAPIAccessorImpl();
            Method m = apiAccessor.getClass().getMethod("get" + className, String.class);
            return m.invoke((Object)apiAccessor, queryList);
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("baie_EJB3I_1", new Object[0]);
            throw new BonitaRuntimeException(message, e);
        }
    }

    public Object performInterception(InvocationContext ctx) throws Exception {
        int i;
        String className = ctx.getTarget().getClass().getSimpleName();
        className = className.substring(0, className.length() - SUFFIX_LENGTH);
        Map options = (Map)ctx.getParameters()[ctx.getParameters().length - 1];
        String queryList = (String)options.get("queryList");
        String user = (String)options.get("user");
        String domain = (String)options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        Class<?>[] currentParameterTypes = ctx.getMethod().getParameterTypes();
        Object[] currentParameterValues = ctx.getParameters();
        Class[] newParameterTypes = new Class[currentParameterTypes.length - 1];
        Object[] newParameterValues = new Object[currentParameterValues.length - 1];
        for (i = 0; i < currentParameterTypes.length - 1; ++i) {
            newParameterTypes[i] = currentParameterTypes[i];
        }
        for (i = 0; i < currentParameterValues.length - 1; ++i) {
            newParameterValues[i] = currentParameterValues[i];
        }
        Object standaloneAPI = this.getStandaloneAPI(className, queryList);
        Method implMethod = null;
        try {
            implMethod = standaloneAPI.getClass().getMethod(ctx.getMethod().getName(), newParameterTypes);
            return implMethod.invoke(standaloneAPI, newParameterValues);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && implMethod != null) {
                Throwable invocationExceptionCause = e.getCause();
                InterceptorUtil.manageInvokeExceptionCause(implMethod, invocationExceptionCause);
            }
            String message = ExceptionManager.getInstance().getFullMessage("baie_EJB3I_2", ctx.getMethod().getName());
            throw new BonitaRuntimeException(message, e);
        }
    }
}

