/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

@Path(value="/API/managementAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface AbstractRemoteManagementAPI
extends Remote {
    @Consumes(value={"application/octet-stream", "text/*", "application/xml"})
    @POST
    @Path(value="deploy")
    public ProcessDefinition deploy(BusinessArchive var1, @HeaderParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @Consumes(value={"application/octet-stream", "text/*", "application/xml"})
    @POST
    @Path(value="deployJar/{jarName}")
    public void deployJar(@PathParam(value="jarName") String var1, byte[] var2, @HeaderParam(value="options") Map<String, String> var3) throws DeploymentException, RemoteException;

    @POST
    @Path(value="removeJar/{jarName}")
    public void removeJar(@PathParam(value="jarName") String var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="deleteProcess/{processUUID}")
    public void deleteProcess(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException, RemoteException;

    @POST
    @Path(value="deleteAllProcesses")
    public void deleteAllProcesses(@FormParam(value="options") Map<String, String> var1) throws UndeletableProcessException, UndeletableInstanceException, RemoteException;

    @POST
    @Path(value="getLoggedUser")
    public String getLoggedUser(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getAvailableJars")
    public Set<String> getAvailableJars(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="addMetaData/{key}/{value}")
    public void addMetaData(@PathParam(value="key") String var1, @PathParam(value="value") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getMetaData/{key}")
    public String getMetaData(@PathParam(value="key") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="deleteMetaData/{key}")
    public void deleteMetaData(@PathParam(value="key") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="disable/{processUUID}")
    public void disable(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="enable/{processUUID}")
    public void enable(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="archive/{processUUID}")
    public void archive(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws DeploymentException, RemoteException;

    @POST
    @Path(value="isUserAdmin/{username}")
    @Produces(value={"text/*"})
    public Boolean isUserAdmin(@PathParam(value="username") String var1, @FormParam(value="options") Map<String, String> var2) throws UserNotFoundException, RemoteException;

    @POST
    @Path(value="checkUserCredentials/{username}")
    @Produces(value={"text/*"})
    public Boolean checkUserCredentials(@PathParam(value="username") String var1, @FormParam(value="password") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="checkUserCredentialsWithPasswordHash/{username}")
    @Produces(value={"text/*"})
    public Boolean checkUserCredentialsWithPasswordHash(@PathParam(value="username") String var1, @FormParam(value="passwordHash") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="createRule/{name}/{label}/{type}")
    public Rule createRule(@PathParam(value="name") String var1, @PathParam(value="label") String var2, @FormParam(value="decription") String var3, @PathParam(value="type") Rule.RuleType var4, @FormParam(value="options") Map<String, String> var5) throws RuleAlreadyExistsException, RemoteException;

    @POST
    @Path(value="getRules/{ruleType}")
    public List<Rule> getRules(@PathParam(value="ruleType") Rule.RuleType var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="pageSige") int var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getNumberOfRules/{ruleType}")
    public long getNumberOfRules(@PathParam(value="ruleType") Rule.RuleType var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getRuleTypePolicy/{ruleType}")
    public PrivilegePolicy getRuleTypePolicy(@PathParam(value="ruleType") Rule.RuleType var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="setRuleTypePolicy/{ruleType}/{newPolicy}")
    public void setRuleTypePolicy(@PathParam(value="ruleType") Rule.RuleType var1, @PathParam(value="newPolicy") PrivilegePolicy var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="deleteRuleByUUID/{ruleUUID}")
    public void deleteRuleByUUID(@PathParam(value="ruleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="getAllRules")
    public List<Rule> getAllRules(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getRuleByUUID/{ruleUUID}")
    public Rule getRuleByUUID(@PathParam(value="ruleUUID") String var1, @FormParam(value="options") Map<String, String> var2) throws RuleNotFoundException, RemoteException;

    @POST
    @Path(value="updateRuleByUUID/{ruleUUID}/{name}/{label}")
    public Rule updateRuleByUUID(@PathParam(value="ruleUUID") String var1, @PathParam(value="name") String var2, @PathParam(value="label") String var3, @FormParam(value="description") String var4, @FormParam(value="options") Map<String, String> var5) throws RuleNotFoundException, RuleAlreadyExistsException, RemoteException;

    @POST
    @Path(value="updateMigrationDate/{processUUID}")
    public void updateMigrationDate(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="migrationDate") Date var2, @FormParam(value="options") Map<String, String> var3) throws ProcessNotFoundException, RemoteException;

    @Consumes(value={"application/octet-stream"})
    @POST
    @Path(value="setResource/{processUUID}")
    public void setResource(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @QueryParam(value="resourcePath") String var2, byte[] var3, @HeaderParam(value="options") Map<String, String> var4) throws ProcessNotFoundException, RemoteException;
}

