/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.exception.CategoryAlreadyExistsException;
import org.ow2.bonita.facade.exception.CategoryNotFoundException;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.runtime.Label;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.LightProcessInstance;

@Path(value="/API/webAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface AbstractRemoteWebAPI
extends Remote {
    @POST
    @Path(value="getSystemLabels/{ownerName}")
    public List<Label> getSystemLabels(@PathParam(value="ownerName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getUserCustomLabels/{ownerName}")
    public List<Label> getUserCustomLabels(@PathParam(value="ownerName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getLabel/{ownerName}/{labelName}")
    public Label getLabel(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getLabels/{ownerName}")
    public Set<Label> getLabels(@PathParam(value="ownerName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="addLabel")
    public void addLabel(@QueryParam(value="labelName") String var1, @QueryParam(value="ownerName") String var2, @QueryParam(value="editableCSSStyleName") String var3, @QueryParam(value="readonlyCSSStyleName") String var4, @QueryParam(value="previewCSSStyleName") String var5, @QueryParam(value="isVisible") boolean var6, @QueryParam(value="hasToBeDisplayed") boolean var7, @QueryParam(value="iconCSSStyle") String var8, @FormParam(value="caseList") Set<ProcessInstanceUUID> var9, @QueryParam(value="displayOrder") int var10, @QueryParam(value="isSystemLabel") boolean var11, @FormParam(value="options") Map<String, String> var12) throws RemoteException;

    @POST
    @Path(value="removeLabel/{ownerName}/{labelName}")
    public void removeLabel(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="addCasesToLabel/{ownerName}/{labelName}")
    public void addCasesToLabel(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @FormParam(value="caseList") Set<ProcessInstanceUUID> var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="removeCasesFromLabel/{ownerName}/{labelName}")
    public void removeCasesFromLabel(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @FormParam(value="caseList") Set<ProcessInstanceUUID> var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="updateLabelCSS/{ownerName}/{labelName}")
    public void updateLabelCSS(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @QueryParam(value="aEditableCSSStyle") String var3, @QueryParam(value="aPreviewCSSStyle") String var4, @QueryParam(value="aReadOnlyCSSStyle") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException;

    @POST
    @Path(value="updateLabelVisibility/{ownerName}/{labelName}/{isVisible}")
    public void updateLabelVisibility(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @PathParam(value="isVisible") boolean var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="updateLabelVisibility/{ownerName}")
    public void updateLabelVisibility(@PathParam(value="ownerName") String var1, @FormParam(value="labelvisibilities") Map<String, Boolean> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="updateLabelName/{ownerName}/{labelName}/{newName}")
    public void updateLabelName(@PathParam(value="ownerName") String var1, @PathParam(value="labelName") String var2, @PathParam(value="newName") String var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getCaseLabels/{ownerName}/{case_}")
    public Set<Label> getCaseLabels(@PathParam(value="ownerName") String var1, @PathParam(value="case_") ProcessInstanceUUID var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getCasesLabels/{ownerName}")
    public Map<ProcessInstanceUUID, Set<Label>> getCasesLabels(@PathParam(value="ownerName") String var1, @FormParam(value="cases") Set<ProcessInstanceUUID> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="removeAllCasesFromLabels")
    public void removeAllCasesFromLabels(@FormParam(value="caseList") Set<ProcessInstanceUUID> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="removeAllLabelsExcept")
    public void removeAllLabelsExcept(@FormParam(value="labelNames") Set<String> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="removeLabels")
    public void removeLabels(@FormParam(value="labelNames") Set<String> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getLabelsByLabelsName/{ownerName}")
    public Set<Label> getLabels(@PathParam(value="ownerName") String var1, @FormParam(value="labelsName") Set<String> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getAllCategories")
    public Set<Category> getAllCategories(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getAllCategoriesByUUIDExcept")
    public Set<Category> getAllCategoriesByUUIDExcept(@FormParam(value="uuids") Set<CategoryUUID> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getCategories")
    public Set<Category> getCategories(@FormParam(value="names") Set<String> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getCategoriesByUUIDs")
    public Set<Category> getCategoriesByUUIDs(@FormParam(value="uuids") Set<CategoryUUID> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="deleteCategories")
    public void deleteCategories(@FormParam(value="categoryNames") Set<String> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="deleteCategoriesByUUIDs")
    public void deleteCategoriesByUUIDs(@FormParam(value="uuids") Set<CategoryUUID> var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getLightProcessInstances/{ownerName}")
    public List<LightProcessInstance> getLightProcessInstances(@PathParam(value="ownerName") String var1, @FormParam(value="theLabelsName") Set<String> var2, @QueryParam(value="startingIndex") int var3, @QueryParam(value="maxElementCount") int var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getCases/{ownerName}")
    public Set<ProcessInstanceUUID> getCases(@PathParam(value="ownerName") String var1, @FormParam(value="labels") Set<String> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="deleteAllCases")
    public void deleteAllCases(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="deletePhantomCases")
    public void deletePhantomCases(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="generateTemporaryToken")
    public String generateTemporaryToken(@FormParam(value="identityKey") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getIdentityKeyFromTemporaryToken/{token}")
    public String getIdentityKeyFromTemporaryToken(@PathParam(value="token") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="executeConnectorAndSetVariables")
    public void executeConnectorAndSetVariables(@FormParam(value="connectorClassName") String var1, @FormParam(value="parameters") Map<String, Object[]> var2, @PathParam(value="activityInstance") ActivityInstance var3, @FormParam(value="context") Map<String, Object> var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, Exception;

    @POST
    @Path(value="executeConnectorAndGetVariablesToSet/{processDefinitionUUID}")
    public Map<String, Object> executeConnectorAndGetVariablesToSet(@FormParam(value="connectorClassName") String var1, @FormParam(value="parameters") Map<String, Object[]> var2, @PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var3, @FormParam(value="context") Map<String, Object> var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, Exception;

    @POST
    @Path(value="setProcessCategories/{processUUID}")
    public LightProcessDefinition setProcessCategories(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="CategoryNames") Set<String> var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="addCategory")
    public void addCategory(@QueryParam(value="name") String var1, @QueryParam(value="iconCSSStyle") String var2, @QueryParam(value="previewCSSStyleName") String var3, @QueryParam(value="cssStyleName") String var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException, CategoryAlreadyExistsException;

    @POST
    @Path(value="updateCategoryByUUID")
    public Category updateCategoryByUUID(@QueryParam(value="value") String var1, @QueryParam(value="name") String var2, @QueryParam(value="iconCSSStyle") String var3, @QueryParam(value="previewCSSStyleName") String var4, @QueryParam(value="cssStyleName") String var5, @FormParam(value="options") Map<String, String> var6) throws RemoteException, CategoryNotFoundException, CategoryAlreadyExistsException;

    @Consumes(value={"application/octet-stream"})
    @POST
    @Path(value="addProcessDocumentTemplate/{processUUID}")
    public Document addProcessDocumentTemplate(@QueryParam(value="name") String var1, @PathParam(value="processUUID") ProcessDefinitionUUID var2, @QueryParam(value="fileName") String var3, @QueryParam(value="mimeType") String var4, byte[] var5, @HeaderParam(value="options") Map<String, String> var6) throws RemoteException, ProcessNotFoundException, DocumentAlreadyExistsException, DocumentationCreationException;

    @POST
    @Path(value="getProcessDocumentTemplates/{processUUID}")
    public List<Document> getProcessDocumentTemplates(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException, DocumentationCreationException;
}

