/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.monitoring.model;

import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.ow2.bonita.facade.monitoring.model.JvmMBean;
import org.ow2.bonita.facade.monitoring.model.MBeanStartException;
import org.ow2.bonita.facade.monitoring.model.MBeanStopException;
import org.ow2.bonita.facade.monitoring.model.impl.MBeanUtil;

public class Jvm
implements JvmMBean {
    protected static final Logger LOG = Logger.getLogger(Jvm.class.getName());
    private final MBeanServer mbserver = MBeanUtil.getMBeanServer();
    private final ObjectName name = new ObjectName("Bonitasoft:name=JVM,type=JVMMBean");
    private ObjectName nameAfterRegistration;
    private final MemoryMXBean memoryMB = MBeanUtil.getMemoryMXBean();
    private final OperatingSystemMXBean osMB = MBeanUtil.getOSMXBean();
    private final RuntimeMXBean runtimeMB = MBeanUtil.getRuntimeMXBean();
    private final ThreadMXBean threadMB = MBeanUtil.getThreadMXBean();

    @Override
    public void start() throws MBeanStartException {
        try {
            if (!this.mbserver.isRegistered(this.name)) {
                ObjectInstance objectInstance = this.mbserver.registerMBean(this, this.name);
                this.nameAfterRegistration = objectInstance.getObjectName();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Registered MBean: " + this.nameAfterRegistration.getCanonicalName());
                }
            }
        }
        catch (Exception e) {
            throw new MBeanStartException(e);
        }
    }

    @Override
    public void stop() throws MBeanStopException {
        try {
            if (this.mbserver.isRegistered(this.name)) {
                this.mbserver.unregisterMBean(this.name);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Un-registered MBean: " + this.name);
                }
            }
            if (this.mbserver.isRegistered(this.nameAfterRegistration)) {
                this.mbserver.unregisterMBean(this.nameAfterRegistration);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Un-registered MBean: " + this.nameAfterRegistration.getCanonicalName());
                }
            }
        }
        catch (Exception e) {
            throw new MBeanStopException(e);
        }
    }

    @Override
    public long getCurrentMemoryUsage() {
        return this.memoryMB.getHeapMemoryUsage().getUsed() + this.memoryMB.getNonHeapMemoryUsage().getUsed();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.osMB.getSystemLoadAverage();
    }

    @Override
    public long getUpTime() {
        return this.runtimeMB.getUptime();
    }

    @Override
    public long getStartTime() {
        return this.runtimeMB.getStartTime();
    }

    @Override
    public long getTotalThreadsCpuTime() {
        long cpuTimeSum = -1L;
        if (this.threadMB.isThreadCpuTimeSupported() && this.threadMB.isThreadCpuTimeEnabled()) {
            long[] threadIds = this.threadMB.getAllThreadIds();
            cpuTimeSum = 0L;
            for (long id : threadIds) {
                cpuTimeSum += this.threadMB.getThreadCpuTime(id);
            }
        }
        return cpuTimeSum;
    }

    @Override
    public int getThreadCount() {
        return this.threadMB.getThreadCount();
    }

    @Override
    public float getMemoryUsagePercentage() {
        float currentUsage = this.memoryMB.getHeapMemoryUsage().getUsed() + this.memoryMB.getNonHeapMemoryUsage().getUsed();
        float maxMemory = this.memoryMB.getHeapMemoryUsage().getMax() + this.memoryMB.getNonHeapMemoryUsage().getMax();
        float percentage = currentUsage / maxMemory;
        return percentage * 100.0f;
    }

    @Override
    public String getOSArch() {
        return this.osMB.getArch();
    }

    @Override
    public int getAvailableProcessors() {
        return this.osMB.getAvailableProcessors();
    }

    @Override
    public String getOSName() {
        return this.osMB.getName();
    }

    @Override
    public String getOSVersion() {
        return this.osMB.getVersion();
    }

    @Override
    public String getJvmName() {
        return this.runtimeMB.getVmName();
    }

    @Override
    public String getJvmVendor() {
        return this.runtimeMB.getVmVendor();
    }

    @Override
    public String getJvmVersion() {
        return this.runtimeMB.getVmVersion();
    }

    @Override
    public Map<String, String> getJvmSystemProperties() {
        return this.runtimeMB.getSystemProperties();
    }
}

