/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.privilege.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.Misc;

public class RuleImpl
extends DescriptionElementImpl
implements Rule {
    private static final long serialVersionUID = -5403223858809095337L;
    protected long dbid;
    protected String uuid;
    protected String name;
    protected String label;
    protected Set<String> exceptions;
    protected String type;
    protected Set<String> entities;
    protected Set<String> users;
    protected Set<String> roles;
    protected Set<String> groups;
    protected Set<String> memberships;

    protected RuleImpl() {
    }

    protected RuleImpl(Rule.RuleType type) {
        Misc.checkArgsNotNull(new Object[]{type});
        this.uuid = UUID.randomUUID().toString();
        this.type = type.name();
    }

    protected RuleImpl(String name, String label, String description, Rule.RuleType type, Set<? extends AbstractUUID> items) {
        Misc.checkArgsNotNull(new Object[]{name, type});
        this.uuid = UUID.randomUUID().toString();
        this.name = name;
        this.label = label;
        if (items != null) {
            this.exceptions = new HashSet<String>();
            for (AbstractUUID abstractUUID : items) {
                this.exceptions.add(abstractUUID.getValue());
            }
        } else {
            this.exceptions = null;
        }
        this.type = type.name();
        this.setDescription(description);
    }

    protected RuleImpl(Rule src) {
        super(src);
        this.dbid = src.getId();
        this.uuid = src.getUUID();
        this.name = src.getName();
        this.label = src.getLabel();
        this.exceptions = new HashSet<String>();
        Set<String> items_ = src.getItems();
        for (String item : items_) {
            this.exceptions.add(item);
        }
        this.type = src.getType().name();
        this.entities = CopyTool.copy(src.getEntities());
        this.users = CopyTool.copy(src.getUsers());
        this.roles = CopyTool.copy(src.getRoles());
        this.groups = CopyTool.copy(src.getGroups());
        this.memberships = CopyTool.copy(src.getMemberships());
    }

    @Override
    @Deprecated
    public long getId() {
        return this.dbid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Set<String> getItems() {
        if (this.exceptions == null) {
            this.exceptions = new HashSet<String>();
        }
        return this.exceptions;
    }

    public void setItems(Set<String> items) {
        Misc.checkArgsNotNull(items);
        this.exceptions = items;
    }

    @Override
    public Rule.RuleType getType() {
        return Rule.RuleType.valueOf(this.type);
    }

    protected <E extends AbstractUUID> void addExceptions(Collection<E> exceptions) {
        Misc.checkArgsNotNull(exceptions);
        if (this.exceptions == null) {
            this.exceptions = new HashSet<String>();
        }
        for (AbstractUUID exception : exceptions) {
            this.exceptions.add(exception.getValue());
        }
    }

    protected <E extends AbstractUUID> void removeExceptions(Collection<E> exceptions) {
        Misc.checkArgsNotNull(exceptions);
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            for (AbstractUUID exception : exceptions) {
                this.exceptions.remove(exception.getValue());
            }
        }
    }

    protected <E extends AbstractUUID> void setExceptions(Set<E> exceptions) {
        Misc.checkArgsNotNull(exceptions);
        HashSet<String> exceptionValues = new HashSet<String>();
        for (AbstractUUID exception : exceptions) {
            exceptionValues.add(exception.getValue());
        }
        this.exceptions = exceptionValues;
    }

    @Override
    public Set<String> getEntities() {
        if (this.entities == null) {
            this.entities = new HashSet<String>();
        }
        return this.entities;
    }

    public void addEntities(Collection<String> entities) {
        Misc.checkArgsNotNull(entities);
        if (this.entities == null) {
            this.entities = new HashSet<String>();
        }
        this.entities.addAll(entities);
    }

    public void removeEntities(Collection<String> entities) {
        Misc.checkArgsNotNull(entities);
        if (this.entities != null && !this.entities.isEmpty()) {
            this.entities.removeAll(entities);
        }
    }

    @Override
    public Set<String> getGroups() {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        return this.groups;
    }

    public void addGroups(Collection<String> groups) {
        Misc.checkArgsNotNull(groups);
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        this.groups.addAll(groups);
    }

    public void removeGroups(Collection<String> groups) {
        Misc.checkArgsNotNull(groups);
        if (this.groups != null && !this.groups.isEmpty()) {
            this.groups.removeAll(groups);
        }
    }

    @Override
    public Set<String> getMemberships() {
        if (this.memberships == null) {
            this.memberships = new HashSet<String>();
        }
        return this.memberships;
    }

    public void addMemberships(Collection<String> memberships) {
        Misc.checkArgsNotNull(memberships);
        if (this.memberships == null) {
            this.memberships = new HashSet<String>();
        }
        this.memberships.addAll(memberships);
    }

    public void removeMemberships(Collection<String> memberships) {
        Misc.checkArgsNotNull(memberships);
        if (this.memberships != null && !this.memberships.isEmpty()) {
            this.memberships.removeAll(memberships);
        }
    }

    @Override
    public Set<String> getRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        return this.roles;
    }

    public void addRoles(Collection<String> roles) {
        Misc.checkArgsNotNull(roles);
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        this.roles.addAll(roles);
    }

    public void removeRoles(Collection<String> roles) {
        Misc.checkArgsNotNull(roles);
        if (this.roles != null && !this.roles.isEmpty()) {
            this.roles.removeAll(roles);
        }
    }

    @Override
    public Set<String> getUsers() {
        if (this.users == null) {
            this.users = new HashSet<String>();
        }
        return this.users;
    }

    public void addUsers(Collection<String> users) {
        Misc.checkArgsNotNull(users);
        if (this.users == null) {
            this.users = new HashSet<String>();
        }
        this.users.addAll(users);
    }

    public void removeUsers(Collection<String> users) {
        Misc.checkArgsNotNull(users);
        if (this.users != null && !this.users.isEmpty()) {
            this.users.removeAll(users);
        }
    }

    public String toString() {
        return this.name + " - " + this.label + " - " + this.type;
    }

    public static Rule createRule(Rule source) {
        return new RuleImpl(source);
    }

    @Override
    public int compareTo(Rule rule) {
        return this.getName().compareTo(rule.getName());
    }
}

