/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.interceptor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.ow2.bonita.facade.rest.stringconverter.MapStringConverter;
import org.ow2.bonita.util.Base64;

@ClientInterceptor
@Provider
public class RESTClientExecutionInterceptor
implements ClientExecutionInterceptor {
    private static final Logger LOG = Logger.getLogger(RESTClientExecutionInterceptor.class.getName());
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private static final String OPTIONS_PROPERTY_NAME = "options";
    private static final String AUTHORIZATION_PROPERTY = "Authorization";

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        MapStringConverter converter;
        Object optionsMap;
        String userName;
        ClientRequest request = ctx.getRequest();
        MultivaluedMap formParameters = request.getFormParameters();
        List options = null;
        if (formParameters != null) {
            options = (List)formParameters.get((Object)OPTIONS_PROPERTY_NAME);
        }
        if (options == null || options.isEmpty()) {
            MultivaluedMap headers = request.getHeaders();
            options = (List)headers.get((Object)OPTIONS_PROPERTY_NAME);
        }
        if ((options == null || options.isEmpty()) && LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("No options map was found!");
            return ctx.proceed();
        }
        if (options.size() > 1 && LOG.isLoggable(Level.SEVERE)) {
            LOG.severe("More than one parameter named options was found!");
        }
        if ((userName = (String)(optionsMap = (converter = new MapStringConverter()).fromString((String)options.get(0))).get("restUser")) != null && !userName.trim().equals("")) {
            String passWord = (String)optionsMap.get("passwordHash");
            String encodedUserAndPswd = Base64.encodeBytes((userName + ":" + passWord).getBytes());
            request.getHeaders().add((Object)AUTHORIZATION_PROPERTY, (Object)("Basic " + encodedUserAndPswd));
        }
        this.encodeParameters(request);
        return ctx.proceed();
    }

    private void encodeParameters(ClientRequest request) {
        this.encodeFormParameters(request);
        this.encodeOptionsHeaderParameter(request);
    }

    private void encodeOptionsHeaderParameter(ClientRequest request) {
        MultivaluedMap headers = request.getHeaders();
        List options = (List)headers.get((Object)OPTIONS_PROPERTY_NAME);
        if (options != null && options.size() > 0) {
            String encodedStrOptions;
            block3: {
                String strOptions = (String)options.get(0);
                encodedStrOptions = null;
                try {
                    encodedStrOptions = URLEncoder.encode(strOptions, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (!LOG.isLoggable(Level.WARNING)) break block3;
                    LOG.log(Level.WARNING, "Impossible to encode some parameters using UTF-8", e);
                }
            }
            headers.remove((Object)OPTIONS_PROPERTY_NAME);
            headers.add((Object)OPTIONS_PROPERTY_NAME, (Object)encodedStrOptions);
        }
    }

    private void encodeFormParameters(ClientRequest request) {
        block2: {
            try {
                MultivaluedMap formParameters = request.getFormParameters();
                this.encodeMultivalueMap((MultivaluedMap<String, String>)formParameters);
            }
            catch (UnsupportedEncodingException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, "Impossible to encode some parameters using UTF-8", e);
            }
        }
    }

    private void encodeMultivalueMap(MultivaluedMap<String, String> parameters) throws UnsupportedEncodingException {
        for (Map.Entry parameter : parameters.entrySet()) {
            ArrayList<String> encodedValues = new ArrayList<String>();
            for (String value : (List)parameter.getValue()) {
                encodedValues.add(URLEncoder.encode(value, "UTF-8"));
            }
            parameters.put(parameter.getKey(), encodedValues);
        }
    }
}

