/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.ow2.bonita.util.Misc;

@Provider
@Consumes(value={"application/octet-stream"})
@Produces(value={"application/octet-stream"})
public class ByteArrayProvider
implements MessageBodyReader<byte[]>,
MessageBodyWriter<byte[]> {
    private static final Logger LOG = Logger.getLogger(ByteArrayProvider.class.getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(byte[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFrom(Class<byte[]> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = entityStream.read(buffer)) != -1) {
                if (read <= 0) continue;
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            baos.close();
        }
    }

    public long getSize(byte[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.length;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(byte[].class);
    }

    public void writeTo(byte[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        block2: {
            try {
                entityStream.write(t);
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block2;
                LOG.severe("Error while serializing the object: " + Misc.getStackTraceFrom(e));
            }
        }
    }
}

