/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest.provider;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.ow2.bonita.facade.CommandAPI;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.rest.wrapper.RESTObject;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.XStreamUtil;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class GenericObjectProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger LOG = Logger.getLogger(GenericObjectProvider.class.getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType.getType().equalsIgnoreCase("application/octet-stream")) {
            return false;
        }
        return this.isReadableOrWriteable(genericType);
    }

    private boolean isReadableOrWriteable(Type genericType) {
        boolean isPrimitive = false;
        boolean isReadableorWriteable = true;
        if (genericType != null) {
            if (genericType instanceof Class) {
                isPrimitive = ((Class)genericType).isPrimitive();
            }
            boolean mustHaveUserProvider = !isPrimitive && !genericType.equals(String.class) && !genericType.equals(Boolean.class) && !genericType.equals(BusinessArchive.class) && !genericType.equals(boolean[].class);
            isReadableorWriteable = genericType.equals(Object.class) || genericType.equals(CommandAPI.class) || mustHaveUserProvider;
        }
        return isReadableorWriteable;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object ret;
        block9: {
            ret = null;
            String content = this.getContent(entityStream);
            if (content.startsWith("<")) {
                XStream xstream = XStreamUtil.getDefaultXstream();
                try {
                    ret = xstream.fromXML(content);
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("Error while decoding " + content + ": " + Misc.getStackTraceFrom(e));
                    }
                    ret = content;
                }
            } else {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("The string does not begin with \"<\". It will be considered as a simple String:" + content);
                }
                ret = content;
            }
            try {
                if (ret instanceof RESTObject) {
                    RESTObject restObject = (RESTObject)ret;
                    ret = restObject.getObject();
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block9;
                LOG.severe(e.getStackTrace().toString());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(InputStream entityStream) throws IOException {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(entityStream, "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                builder.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Error while reading the InputStream: " + Misc.getStackTraceFrom(e));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        String result = builder.toString();
        return result.trim();
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType.getType().equalsIgnoreCase("application/octet-stream")) {
            return false;
        }
        return this.isReadableOrWriteable(genericType);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        block2: {
            XStream xstream = XStreamUtil.getDefaultXstream();
            try {
                xstream.toXML(t, entityStream);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block2;
                LOG.severe("Error while writing in the OutputStream: " + Misc.getStackTraceFrom(e));
            }
        }
    }
}

