/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.IdentityAPI;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.util.Command;

public class WebAddUserCommand
implements Command<User> {
    private static final long serialVersionUID = 9213686743956422618L;
    private static final String WEBSITE_KEY = "website";
    private static final String COUNTRY_KEY = "country";
    private static final String STATE_KEY = "state";
    private static final String CITY_KEY = "city";
    private static final String ZIPCODE_KEY = "zip";
    private static final String ADDRESS_KEY = "address";
    private static final String ROOM_KEY = "room";
    private static final String BUILDING_KEY = "building";
    private static final String FAX_NUMBER_KEY = "fax";
    private static final String MOBILE_NUMBER_KEY = "mobile";
    private static final String PHONE_NUMBER_KEY = "phone";
    private static final String EMAIL_KEY = "email";
    private String username;
    private String firstName;
    private String lastName;
    private String password;
    private Map<String, List<String>> memberships;
    private Map<String, String> metadata;
    private final String title;
    private final String jobTitle;
    private final String managerUuid;
    private final Map<String, String> personalContactInfo;
    private final Map<String, String> professionalContactInfo;
    private final String delegateUuid;

    public WebAddUserCommand(String username, String firstName, String lastName, String password, String title, String jobTitle, String managerUuid, String delegateUuid, Map<String, String> personalContactInfo, Map<String, String> professionalContactInfo, Map<String, List<String>> memberships, Map<String, String> metadata) {
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.password = password;
        this.title = title;
        this.jobTitle = jobTitle;
        this.managerUuid = managerUuid;
        this.delegateUuid = delegateUuid;
        this.personalContactInfo = personalContactInfo != null ? new HashMap<String, String>(personalContactInfo) : new HashMap<String, String>();
        this.professionalContactInfo = professionalContactInfo != null ? new HashMap<String, String>(professionalContactInfo) : new HashMap<String, String>();
        this.memberships = memberships;
        this.metadata = metadata;
    }

    @Override
    public User execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        IdentityAPI identityAPI = accessor.getIdentityAPI();
        User user = identityAPI.addUser(this.username, this.password, this.firstName, this.lastName, this.title, this.jobTitle, this.managerUuid, this.metadata);
        identityAPI.updateUserDelegee(user.getUUID(), this.delegateUuid);
        identityAPI.updateUserPersonalContactInfo(user.getUUID(), this.personalContactInfo.get(EMAIL_KEY), this.personalContactInfo.get(PHONE_NUMBER_KEY), this.personalContactInfo.get(MOBILE_NUMBER_KEY), this.personalContactInfo.get(FAX_NUMBER_KEY), this.personalContactInfo.get(BUILDING_KEY), this.personalContactInfo.get(ROOM_KEY), this.personalContactInfo.get(ADDRESS_KEY), this.personalContactInfo.get(ZIPCODE_KEY), this.personalContactInfo.get(CITY_KEY), this.personalContactInfo.get(STATE_KEY), this.personalContactInfo.get(COUNTRY_KEY), this.personalContactInfo.get(WEBSITE_KEY));
        identityAPI.updateUserProfessionalContactInfo(user.getUUID(), this.professionalContactInfo.get(EMAIL_KEY), this.professionalContactInfo.get(PHONE_NUMBER_KEY), this.professionalContactInfo.get(MOBILE_NUMBER_KEY), this.professionalContactInfo.get(FAX_NUMBER_KEY), this.professionalContactInfo.get(BUILDING_KEY), this.professionalContactInfo.get(ROOM_KEY), this.professionalContactInfo.get(ADDRESS_KEY), this.professionalContactInfo.get(ZIPCODE_KEY), this.professionalContactInfo.get(CITY_KEY), this.professionalContactInfo.get(STATE_KEY), this.professionalContactInfo.get(COUNTRY_KEY), this.professionalContactInfo.get(WEBSITE_KEY));
        ArrayList<String> ms = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.memberships.entrySet()) {
            String groupId = entry.getKey();
            for (String roleId : entry.getValue()) {
                ms.add(identityAPI.getMembershipForRoleAndGroup(roleId, groupId).getUUID());
            }
        }
        identityAPI.setUserMemberships(user.getUUID(), ms);
        return identityAPI.getUserByUUID(user.getUUID());
    }
}

