/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.util.Command;

public class WebDeleteDocumentsOfProcessCommand
implements Command<Void> {
    private static final long serialVersionUID = -4049500711900576134L;
    private ProcessDefinitionUUID processUUID;
    private boolean deleteAttachments;

    public WebDeleteDocumentsOfProcessCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    public WebDeleteDocumentsOfProcessCommand(ProcessDefinitionUUID processUUID, boolean deleteAttachments) {
        this.processUUID = processUUID;
        this.deleteAttachments = deleteAttachments;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        this.deleteAttachments(this.processUUID);
        return null;
    }

    private void deleteAttachments(ProcessDefinitionUUID uuid) throws DocumentNotFoundException {
        DocumentResult searchResult;
        DocumentSearchBuilder documentSearchBuilder = new DocumentSearchBuilder();
        documentSearchBuilder.criterion(this.deleteAttachments ? DocumentIndex.PROCESS_DEFINITION_UUID : DocumentIndex.PROCESS_DEFINITION_UUID_WITHOUT_INSTANCES).equalsTo(uuid.getValue());
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        do {
            List<Document> documentsFound;
            if ((documentsFound = (searchResult = queryRuntimeAPI.searchDocuments(documentSearchBuilder, 0, 100)).getDocuments()).size() <= 0) continue;
            DocumentUUID[] documentsToDelete = new DocumentUUID[documentsFound.size()];
            int i = 0;
            for (Document document : documentsFound) {
                documentsToDelete[i] = document.getUUID();
                ++i;
            }
            runtimeAPI.deleteDocuments(true, documentsToDelete);
        } while (searchResult.getCount() > 0);
    }
}

