/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.search.DocumentResult;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.util.Command;

public class WebDeleteDocumentsOfProcessesCommand
implements Command<Void> {
    private static final long serialVersionUID = -4049500711900576134L;
    private final Collection<ProcessDefinitionUUID> processUUIDs;
    private final boolean deleteAttachments;
    private static final Logger LOGGER = Logger.getLogger(WebDeleteDocumentsOfProcessesCommand.class.getName());

    public WebDeleteDocumentsOfProcessesCommand(Collection<ProcessDefinitionUUID> processUUIDs) {
        this.processUUIDs = processUUIDs;
        this.deleteAttachments = false;
        Logger.getLogger(WebDeleteDocumentsOfProcessesCommand.class.getName());
    }

    public WebDeleteDocumentsOfProcessesCommand(Collection<ProcessDefinitionUUID> processUUIDs, boolean deleteAttachments) {
        this.processUUIDs = processUUIDs;
        this.deleteAttachments = deleteAttachments;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        for (ProcessDefinitionUUID processUUID : this.processUUIDs) {
            this.deleteAttachments(processUUID);
        }
        if (this.deleteAttachments) {
            try {
                Class<?> serverCommandClass = Class.forName("org.ow2.bonita.util.ServerWebDeleteDocumentsOfProcessesCommand");
                Command serverCommand = (Command)serverCommandClass.getConstructor(Collection.class).newInstance(this.processUUIDs);
                serverCommand.execute(null);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to delete folder of the process definition on document server", e);
            }
        }
        return null;
    }

    private void deleteAttachments(ProcessDefinitionUUID uuid) throws DocumentNotFoundException {
        DocumentResult searchResult;
        DocumentSearchBuilder documentSearchBuilder = new DocumentSearchBuilder();
        documentSearchBuilder.criterion(this.deleteAttachments ? DocumentIndex.PROCESS_DEFINITION_UUID : DocumentIndex.PROCESS_DEFINITION_UUID_WITHOUT_INSTANCES).equalsTo(uuid.getValue());
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        do {
            searchResult = queryRuntimeAPI.searchDocuments(documentSearchBuilder, 0, 100);
            List<Document> documentsFound = searchResult.getDocuments();
            DocumentUUID[] documentsToDelete = new DocumentUUID[documentsFound.size()];
            int i = 0;
            for (Document document : documentsFound) {
                documentsToDelete[i] = document.getUUID();
                ++i;
            }
            runtimeAPI.deleteDocuments(true, documentsToDelete);
        } while (searchResult.getCount() > 0);
    }
}

