/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebGetLightParentProcessInstances
implements Command<List<LightProcessInstance>> {
    private static final long serialVersionUID = 4223637974438770807L;
    private int fromIndex;
    private int pageSize;
    private boolean searchInHistory;

    public WebGetLightParentProcessInstances(int fromIndex, int pageSize, boolean searchInHistory) {
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
    }

    @Override
    public List<LightProcessInstance> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        List<LightProcessInstance> result = queryRuntimeAPI.getLightParentProcessInstances(this.fromIndex, this.pageSize);
        return result;
    }
}

