/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Command;

public class WebGetNumberOfManageableParentProcessInstances
implements Command<Integer> {
    private static final long serialVersionUID = 4223637974438770807L;
    private boolean searchInHistory;
    private final String userID;
    private final Set<String> roleUUIDs;
    private final Set<String> groupUUIDs;
    private final Set<String> membershipUUIDs;
    private final String entityID;

    public WebGetNumberOfManageableParentProcessInstances(boolean searchInHistory, String userID, Set<String> userRoles, Set<String> userGroups, Set<String> userMemberships, String userName) {
        this.searchInHistory = searchInHistory;
        this.userID = userID;
        this.roleUUIDs = userRoles;
        this.groupUUIDs = userGroups;
        this.membershipUUIDs = userMemberships;
        this.entityID = userName;
    }

    @Override
    public Integer execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        List<Object> applicableRules = new ArrayList();
        HashSet<String> exceptions = new HashSet<String>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_MANAGE, this.userID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy privilegePolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_MANAGE);
        switch (privilegePolicy) {
            case ALLOW_BY_DEFAULT: {
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    return queryRuntimeAPI.getNumberOfParentProcessInstancesExcept(processUUIDs);
                }
                return queryRuntimeAPI.getNumberOfParentProcessInstances();
            }
            case DENY_BY_DEFAULT: {
                if (processUUIDs.size() > 0) {
                    return queryRuntimeAPI.getNumberOfParentProcessInstances(processUUIDs);
                }
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

