/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.GroovyException;

public class WebInstantiateProcess
implements Command<ProcessInstanceUUID> {
    private static final long serialVersionUID = -6141460318114068466L;
    private static final Logger LOG = Logger.getLogger(WebInstantiateProcess.class.getName());
    protected ProcessDefinitionUUID processDefinitionUUID;
    protected Map<String, Object> processVariables;
    protected Set<InitialAttachment> attachments;
    protected List<String> scriptsToExecute;
    protected Map<String, Object> scriptContext;

    public WebInstantiateProcess(ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> processVariables, Set<InitialAttachment> attachments, List<String> scriptsToExecute, Map<String, Object> scriptContext) {
        this.processDefinitionUUID = processDefinitionUUID;
        this.processVariables = processVariables;
        this.attachments = attachments;
        this.scriptsToExecute = scriptsToExecute;
        this.scriptContext = scriptContext;
    }

    protected void executeActions(RuntimeAPI runtimeAPI) throws Exception {
        if (this.scriptsToExecute != null && !this.scriptsToExecute.isEmpty()) {
            HashMap<String, String> scriptsToExecuteInASingleCall = new HashMap<String, String>(this.scriptsToExecute.size());
            for (String scriptToExecute : this.scriptsToExecute) {
                scriptsToExecuteInASingleCall.put(String.valueOf(scriptsToExecuteInASingleCall.size()), scriptToExecute);
            }
            try {
                runtimeAPI.evaluateGroovyExpressions(scriptsToExecuteInASingleCall, this.processDefinitionUUID, this.scriptContext);
            }
            catch (GroovyException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Error while executing action. unable to evaluate the groovy expression", e);
                }
                throw new GroovyException(e.getMessage(), e);
            }
        }
    }

    @Override
    public ProcessInstanceUUID execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        this.executeActions(runtimeAPI);
        return runtimeAPI.instantiateProcess(this.processDefinitionUUID, this.processVariables, this.attachments);
    }
}

