/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;

public class WebIsUserActiveInProcessInstancesCommand
implements Command<Map<ProcessInstanceUUID, Boolean>> {
    private static final long serialVersionUID = -8687520379012488413L;
    private final Set<ProcessInstanceUUID> instanceUUIDs;
    private final String username;

    public WebIsUserActiveInProcessInstancesCommand(Set<ProcessInstanceUUID> instanceUUIDs, String username) {
        this.instanceUUIDs = instanceUUIDs;
        this.username = username;
    }

    @Override
    public Map<ProcessInstanceUUID, Boolean> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI journalQueryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
        HashMap<ProcessInstanceUUID, Boolean> instances = new HashMap<ProcessInstanceUUID, Boolean>();
        Map<ProcessInstanceUUID, Set<String>> users = journalQueryRuntimeAPI.getActiveUsersOfProcessInstances(this.instanceUUIDs);
        for (ProcessInstanceUUID uuid : this.instanceUUIDs) {
            instances.put(uuid, users != null && users.get(uuid) != null && users.get(uuid).contains(this.username));
        }
        return instances;
    }
}

