/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.command.WebSearchResult;
import org.ow2.bonita.search.SearchQueryBuilder;
import org.ow2.bonita.util.Command;

public class WebSearchUsers
implements Command<WebSearchResult<User>> {
    private static final long serialVersionUID = -5386146444505586809L;
    private int fromIndex;
    private int pageSize;
    private boolean searchInHistory;
    private SearchQueryBuilder query;

    public WebSearchUsers(SearchQueryBuilder query, int fromIndex, int pageSize, boolean searchInHistory) {
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
        this.searchInHistory = searchInHistory;
        this.query = query;
    }

    @Override
    public WebSearchResult<User> execute(Environment environment) throws Exception {
        List users;
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = this.searchInHistory ? accessor.getQueryRuntimeAPI("historyQueryList") : accessor.getQueryRuntimeAPI("journalQueryList");
        int nbOfPossibleResults = queryRuntimeAPI.search(this.query);
        if (nbOfPossibleResults > this.fromIndex && (users = queryRuntimeAPI.search(this.query, this.fromIndex, this.pageSize)) != null) {
            return new WebSearchResult<User>(users, nbOfPossibleResults);
        }
        return new WebSearchResult<User>(new ArrayList(), nbOfPossibleResults);
    }
}

