/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import com.thoughtworks.xstream.XStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.XStreamUtil;

public class AttachmentInstanceImpl
implements AttachmentInstance {
    private static final long serialVersionUID = -4911584710221345476L;
    protected long dbid;
    private DocumentUUID attachmentUUID;
    protected String name;
    protected String label;
    protected String description;
    protected String fileName;
    protected Map<String, String> metaData;
    protected ProcessInstanceUUID processInstanceUUID;
    protected String author;
    protected long versionDate;

    public AttachmentInstanceImpl() {
    }

    public AttachmentInstanceImpl(DocumentUUID attachmentUUID, InitialAttachment attachment, ProcessInstanceUUID processInstanceUUID, String author, Date versionDate) {
        Misc.checkArgsNotNull(attachment.getName(), processInstanceUUID, author, versionDate);
        this.attachmentUUID = attachmentUUID;
        this.name = attachment.getName();
        this.processInstanceUUID = processInstanceUUID;
        this.author = author;
        this.versionDate = Misc.getTime(versionDate);
        this.label = attachment.getLabel();
        this.description = attachment.getDescription();
        this.fileName = attachment.getFileName();
        this.metaData = attachment.getMetaData();
    }

    public AttachmentInstanceImpl(DocumentUUID attachmentUUID, String name, ProcessInstanceUUID processInstanceUUID, String author, Date versionDate) {
        Misc.checkArgsNotNull(name, processInstanceUUID, author, versionDate);
        this.attachmentUUID = attachmentUUID;
        this.name = name;
        this.processInstanceUUID = processInstanceUUID;
        this.author = author;
        this.versionDate = Misc.getTime(versionDate);
    }

    @Deprecated
    public AttachmentInstanceImpl(String name, ProcessInstanceUUID processInstanceUUID, String author, Date versionDate) {
        Misc.checkArgsNotNull(name, processInstanceUUID, author, versionDate);
        this.attachmentUUID = null;
        this.name = name;
        this.processInstanceUUID = processInstanceUUID;
        this.author = author;
        this.versionDate = Misc.getTime(versionDate);
    }

    public AttachmentInstanceImpl(AttachmentInstance src) {
        this.attachmentUUID = src.getUUID();
        this.name = src.getName();
        this.processInstanceUUID = src.getProcessInstanceUUID();
        this.author = src.getAuthor();
        this.versionDate = Misc.getTime(src.getVersionDate());
        this.label = src.getLabel();
        this.description = src.getDescription();
        this.fileName = src.getFileName();
        this.metaData = CopyTool.copy(src.getMetaData());
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    @Override
    public DocumentUUID getUUID() {
        return this.attachmentUUID;
    }

    @Override
    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.processInstanceUUID;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getVersionDate() {
        return Misc.getDate(this.versionDate);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Map<String, String> getMetaData() {
        if (this.metaData == null) {
            return Collections.emptyMap();
        }
        return this.metaData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        XStream xstream = XStreamUtil.getDefaultXstream();
        return xstream.toXML((Object)this);
    }
}

