/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.util.Date;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;

public class DocumentImpl
implements Document {
    private static final long serialVersionUID = 2790236426040604303L;
    private final DocumentUUID uuid;
    private final String name;
    private final ProcessDefinitionUUID processDefinitionUUID;
    private final ProcessInstanceUUID processInstanceUUID;
    private final String author;
    private final Date creationDate;
    private final String lastModifiedBy;
    private final Date lastModificationDate;
    private final boolean isLatestVersion;
    private final boolean isMajorVersion;
    private final String versionLabel;
    private final String versionSeriesId;
    public final String contentMimeType;
    public final String contentFileName;
    public final long contentSize;

    public DocumentImpl(DocumentUUID uuid, String name, ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String author, Date creationDate, String lastModifiedBy, Date lastModificationDate, boolean isLatestVersion, boolean isMajorVersion, String versionLabel, String versionSeriesId, String contentFileName, String contentMimeType, long contentSize) {
        this.uuid = uuid;
        this.name = name;
        this.processDefinitionUUID = processDefinitionUUID;
        this.processInstanceUUID = processInstanceUUID;
        this.author = author;
        this.creationDate = new Date(creationDate.getTime());
        this.lastModifiedBy = lastModifiedBy;
        this.lastModificationDate = new Date(lastModificationDate.getTime());
        this.isLatestVersion = isLatestVersion;
        this.isMajorVersion = isMajorVersion;
        this.versionLabel = versionLabel;
        this.versionSeriesId = versionSeriesId;
        this.contentFileName = contentFileName;
        this.contentMimeType = contentMimeType;
        this.contentSize = contentSize;
    }

    @Override
    public DocumentUUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processDefinitionUUID;
    }

    @Override
    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.processInstanceUUID;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    @Override
    public boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    @Override
    public boolean isMajorVersion() {
        return this.isMajorVersion;
    }

    @Override
    public String getVersionLabel() {
        return this.versionLabel;
    }

    @Override
    public String getVersionSeriesId() {
        return this.versionSeriesId;
    }

    @Override
    public String getContentMimeType() {
        return this.contentMimeType;
    }

    @Override
    public String getContentFileName() {
        return this.contentFileName;
    }

    @Override
    public long getContentSize() {
        return this.contentSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.contentFileName == null ? 0 : this.contentFileName.hashCode());
        result = 31 * result + (this.contentMimeType == null ? 0 : this.contentMimeType.hashCode());
        result = 31 * result + (int)(this.contentSize ^ this.contentSize >>> 32);
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (this.isLatestVersion ? 1231 : 1237);
        result = 31 * result + (this.isMajorVersion ? 1231 : 1237);
        result = 31 * result + (this.lastModificationDate == null ? 0 : this.lastModificationDate.hashCode());
        result = 31 * result + (this.lastModifiedBy == null ? 0 : this.lastModifiedBy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.processDefinitionUUID == null ? 0 : this.processDefinitionUUID.hashCode());
        result = 31 * result + (this.processInstanceUUID == null ? 0 : this.processInstanceUUID.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + (this.versionLabel == null ? 0 : this.versionLabel.hashCode());
        result = 31 * result + (this.versionSeriesId == null ? 0 : this.versionSeriesId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentImpl other = (DocumentImpl)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.contentFileName == null ? other.contentFileName != null : !this.contentFileName.equals(other.contentFileName)) {
            return false;
        }
        if (this.contentMimeType == null ? other.contentMimeType != null : !this.contentMimeType.equals(other.contentMimeType)) {
            return false;
        }
        if (this.contentSize != other.contentSize) {
            return false;
        }
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.isLatestVersion != other.isLatestVersion) {
            return false;
        }
        if (this.isMajorVersion != other.isMajorVersion) {
            return false;
        }
        if (this.lastModificationDate == null ? other.lastModificationDate != null : !this.lastModificationDate.equals(other.lastModificationDate)) {
            return false;
        }
        if (this.lastModifiedBy == null ? other.lastModifiedBy != null : !this.lastModifiedBy.equals(other.lastModifiedBy)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.processDefinitionUUID == null ? other.processDefinitionUUID != null : !this.processDefinitionUUID.equals(other.processDefinitionUUID)) {
            return false;
        }
        if (this.processInstanceUUID == null ? other.processInstanceUUID != null : !this.processInstanceUUID.equals(other.processInstanceUUID)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.versionLabel == null ? other.versionLabel != null : !this.versionLabel.equals(other.versionLabel)) {
            return false;
        }
        return !(this.versionSeriesId == null ? other.versionSeriesId != null : !this.versionSeriesId.equals(other.versionSeriesId));
    }
}

