/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.identity.auth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.ow2.bonita.identity.auth.BonitaRemoteLoginModule;
import org.ow2.bonita.identity.auth.MissingOptionException;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class BonitaRESTLoginModule
extends BonitaRemoteLoginModule {
    public static final String REST_USER_OPTION_NAME = "restUser";
    public static final String REST_PSWD_OPTION_NAME = "restPassword";
    private String restId;
    private String restPswd;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.restId = (String)options.get(REST_USER_OPTION_NAME);
        this.restPswd = (String)options.get(REST_PSWD_OPTION_NAME);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.restId == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_MOE_1", REST_USER_OPTION_NAME);
            throw new MissingOptionException("bi_MOE_1", message);
        }
        if (this.restPswd == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_MOE_1", REST_PSWD_OPTION_NAME);
            throw new MissingOptionException("bi_MOE_1", message);
        }
        return super.login();
    }

    @Override
    public boolean commit() throws LoginException {
        super.commit();
        RESTUserOwner.setUser(this.restId);
        PasswordOwner.setPassword(Misc.hash(this.restPswd));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        super.abort();
        PasswordOwner.setPassword(null);
        RESTUserOwner.setUser(null);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        super.logout();
        PasswordOwner.setPassword(null);
        RESTUserOwner.setUser(null);
        return true;
    }
}

