/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.iteration;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.iteration.IterationTransition;

public class IterationNode
implements Comparable<IterationNode> {
    private final String name;
    private JoinType joinType;
    private SplitType splitType;
    private final Set<IterationTransition> incomingTransitions = new HashSet<IterationTransition>();
    private final Set<IterationTransition> outgoingTransitions = new HashSet<IterationTransition>();

    public IterationNode(String name) {
        this.name = name;
    }

    public IterationNode(String name, JoinType joinType, SplitType splitType) {
        this(name);
        this.joinType = joinType;
        this.splitType = splitType;
    }

    public String getName() {
        return this.name;
    }

    public Set<IterationTransition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public Set<IterationTransition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    public void addIncomingTransition(IterationTransition t) {
        this.incomingTransitions.add(t);
    }

    public void addOutgoingTransition(IterationTransition t) {
        this.outgoingTransitions.add(t);
    }

    public void removeOutgoingTransition(IterationTransition transition) {
        this.outgoingTransitions.remove(transition);
    }

    public void removeIncomingTransition(IterationTransition transition) {
        this.incomingTransitions.remove(transition);
    }

    public boolean hasOutgoingTransitions() {
        return !this.outgoingTransitions.isEmpty();
    }

    public boolean hasIncomingTransitions() {
        return !this.incomingTransitions.isEmpty();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public SplitType getSplitType() {
        return this.splitType;
    }

    public String toString() {
        return "IterationNode [name=" + this.name + ", joinType=" + (Object)((Object)this.joinType) + ", splitType=" + (Object)((Object)this.splitType) + "]";
    }

    @Override
    public int compareTo(IterationNode anotherIterationNode) {
        return this.toString().compareTo(anotherIterationNode.toString());
    }

    public static enum SplitType {
        AND,
        XOR;

    }

    public static enum JoinType {
        AND,
        XOR;

    }
}

