/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Date;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightTaskInstance;
import org.ow2.bonita.util.Misc;

public class LightActivityInstanceImpl
extends RuntimeRecordImpl
implements LightTaskInstance {
    private static final long serialVersionUID = -8515098234372896097L;
    protected ActivityInstanceUUID uuid;
    protected String iterationId;
    protected String activityInstanceId;
    protected String loopId;
    protected ActivityState state;
    protected String userId;
    protected long lastUpdate;
    protected String label;
    protected String description;
    protected String dynamicLabel;
    protected String dynamicDescription;
    protected String name;
    protected long startedDate;
    protected long endedDate;
    protected long readyDate;
    protected String endedBy;
    protected String startedBy;
    protected String executionSummary;
    protected ActivityDefinitionUUID activityDefinitionUUID;
    protected long expectedEndDate;
    protected int priority;
    protected ActivityDefinition.Type type;
    protected ProcessInstanceUUID subflowProcessInstanceUUID;
    protected boolean human = false;

    protected LightActivityInstanceImpl() {
    }

    public LightActivityInstanceImpl(ActivityInstanceUUID uuid, ActivityDefinition activityDefinition, ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, String iterationId, String activityInstanceId, String loopId) {
        super(processUUID, instanceUUID, rootInstanceUUID);
        Misc.checkArgsNotNull(uuid, activityDefinition);
        this.uuid = uuid;
        this.iterationId = iterationId;
        this.activityInstanceId = activityInstanceId;
        this.loopId = loopId;
        this.state = ActivityState.READY;
        this.lastUpdate = System.currentTimeMillis();
        this.activityDefinitionUUID = activityDefinition.getUUID();
        this.priority = activityDefinition.getPriority();
        this.type = activityDefinition.getType();
        this.name = activityDefinition.getName();
        this.description = activityDefinition.getDescription();
        this.label = activityDefinition.getLabel();
        this.human = this.isTask();
        long executingTime = activityDefinition.getExecutingTime();
        if (executingTime > 0L) {
            this.expectedEndDate = System.currentTimeMillis() + executingTime;
        }
    }

    public LightActivityInstanceImpl(ActivityInstance src) {
        super(src);
        this.uuid = new ActivityInstanceUUID(src.getUUID());
        this.iterationId = src.getIterationId();
        this.activityInstanceId = src.getActivityInstanceId();
        this.loopId = src.getLoopId();
        this.lastUpdate = Misc.getTime(src.getLastUpdateDate());
        this.startedDate = Misc.getTime(src.getStartedDate());
        this.endedDate = Misc.getTime(src.getEndedDate());
        this.expectedEndDate = Misc.getTime(src.getExpectedEndDate());
        this.readyDate = Misc.getTime(src.getReadyDate());
        this.activityDefinitionUUID = new ActivityDefinitionUUID(src.getActivityDefinitionUUID());
        if (src.getSubflowProcessInstanceUUID() != null) {
            this.subflowProcessInstanceUUID = new ProcessInstanceUUID(src.getSubflowProcessInstanceUUID());
        }
        this.priority = src.getPriority();
        this.type = src.getType();
        this.name = src.getActivityName();
        this.description = src.getActivityDescription();
        this.label = src.getActivityLabel();
        this.dynamicDescription = src.getDynamicDescription();
        this.dynamicLabel = src.getDynamicLabel();
        this.executionSummary = src.getDynamicExecutionSummary();
        if (src.isTask()) {
            TaskInstance task = src.getTask();
            this.human = true;
            this.startedBy = task.getStartedBy();
            this.endedBy = task.getEndedBy();
            this.userId = task.getTaskUser();
        }
        this.state = src.getState();
    }

    @Override
    public String getActivityLabel() {
        return this.label;
    }

    @Override
    public String getActivityDescription() {
        return this.description;
    }

    @Override
    public String getDynamicDescription() {
        return this.dynamicDescription;
    }

    @Override
    public String getDynamicLabel() {
        return this.dynamicLabel;
    }

    public String toString() {
        String userId;
        try {
            userId = this.getTaskUser();
        }
        catch (IllegalStateException e) {
            userId = null;
        }
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", activityId: " + this.getActivityName() + ", iterationId: " + this.getIterationId() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", readyDate: " + this.getReadyDate() + ", userId: " + userId + ", state: " + (Object)((Object)this.getState()) + ", createdDate: " + this.getCreatedDate() + ", startedBy: " + this.getStartedBy() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", endedBy: " + this.getEndedBy() + "]";
        return st;
    }

    @Override
    public LightTaskInstance getTask() {
        if (this.isTask()) {
            return this;
        }
        return null;
    }

    @Override
    public String getIterationId() {
        return this.iterationId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public String getLoopId() {
        return this.loopId;
    }

    @Override
    public String getActivityName() {
        return this.name;
    }

    @Override
    public ActivityInstanceUUID getUUID() {
        return this.uuid;
    }

    @Override
    public Date getStartedDate() {
        return Misc.getDate(this.startedDate);
    }

    @Override
    public Date getEndedDate() {
        return Misc.getDate(this.endedDate);
    }

    @Override
    public Date getReadyDate() {
        return Misc.getDate(this.readyDate);
    }

    @Override
    public Date getCreatedDate() {
        return this.getReadyDate();
    }

    @Override
    public String getEndedBy() {
        return this.endedBy;
    }

    @Override
    public String getStartedBy() {
        return this.startedBy;
    }

    @Override
    public ActivityState getState() {
        return this.state;
    }

    @Override
    public String getTaskUser() {
        return this.userId;
    }

    @Override
    public boolean isTaskAssigned() {
        return this.userId != null;
    }

    @Override
    public Date getLastUpdateDate() {
        return Misc.getDate(this.lastUpdate);
    }

    @Override
    public ActivityDefinitionUUID getActivityDefinitionUUID() {
        return this.activityDefinitionUUID;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getExpectedEndDate() {
        return Misc.getDate(this.expectedEndDate);
    }

    @Override
    public ProcessInstanceUUID getSubflowProcessInstanceUUID() {
        return this.subflowProcessInstanceUUID;
    }

    @Override
    public boolean isAutomatic() {
        return ActivityDefinition.Type.Automatic.equals((Object)this.getType());
    }

    @Override
    public boolean isSubflow() {
        return ActivityDefinition.Type.Subflow.equals((Object)this.getType());
    }

    @Override
    public boolean isTimer() {
        return ActivityDefinition.Type.Timer.equals((Object)this.getType());
    }

    @Override
    public boolean isTask() {
        return ActivityDefinition.Type.Human.equals((Object)this.getType());
    }

    @Override
    public ActivityDefinition.Type getType() {
        return this.type;
    }

    @Override
    public String getDynamicExecutionSummary() {
        return this.executionSummary;
    }
}

