/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.List;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.TagBinding;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public abstract class ElementBinding
extends TagBinding {
    protected ElementBinding(String tagName) {
        super(tagName, "", "majorElements");
    }

    protected <T> T getObject(Class<T> clazz, Parse parse) {
        return parse.findObject(clazz);
    }

    protected String getChildTextContent(Element fatherElement, String childTagName) {
        if (fatherElement == null) {
            return null;
        }
        Element childElement = XmlUtil.element(fatherElement, childTagName);
        if (childElement != null) {
            return childElement.getTextContent().trim();
        }
        return null;
    }

    protected <T extends Enum<T>> T getEnumValue(Class<T> enumType, String valueAsString, T defaultValue) {
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return Misc.stringToEnum(enumType, valueAsString);
        }
        catch (IllegalArgumentException e) {
            String message = ExceptionManager.getInstance().getMessage("bpx_EB_1", valueAsString, enumType.getName());
            throw new BonitaRuntimeException(message, e);
        }
    }

    protected void parseElementList(Element parentElement, String listName, String elementName, Parse parse, Parser parser) {
        List<Element> subElements;
        Element listElement = XmlUtil.element(parentElement, listName);
        if (listElement != null && (subElements = XmlUtil.elements(listElement, elementName)) != null) {
            for (Element subElement : subElements) {
                parser.parseElement(subElement, parse, "majorElements");
            }
        }
    }
}

