/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class EventSubProcessBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(EventSubProcessBinding.class.getName());

    public EventSubProcessBinding() {
        super("event-sub-process");
    }

    @Override
    public Object parse(Element eventSubProcessElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + eventSubProcessElement);
        }
        String name = null;
        try {
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(eventSubProcessElement, "name");
            String label = this.getChildTextContent(eventSubProcessElement, "label");
            String description = this.getChildTextContent(eventSubProcessElement, "description");
            String version = this.getChildTextContent(eventSubProcessElement, "version");
            processBuilder.addEventSubProcess(name, version);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Event sub-process " + name, e);
        }
        return null;
    }
}

