/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.def.binding;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.def.binding.ElementBinding;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.GroovyExpression;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ParticipantBinding
extends ElementBinding {
    private static final Logger LOGGER = Logger.getLogger(ParticipantBinding.class.getName());

    public ParticipantBinding() {
        super("participant");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object parse(Element participantElement, Parse parse, Parser parser) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("parsing element = " + participantElement);
        }
        String name = null;
        try {
            ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
            name = XmlUtil.attribute(participantElement, "name");
            String label = this.getChildTextContent(participantElement, "label");
            String description = this.getChildTextContent(participantElement, "description");
            Element roleMapperElement = XmlUtil.element(participantElement, "role-mapper");
            if (XmlUtil.elements(roleMapperElement) == null || XmlUtil.elements(roleMapperElement).isEmpty()) {
                processBuilder.addHuman(name);
                processBuilder.addDescription(description);
                processBuilder.addLabel(label);
                return null;
            }
            processBuilder.addGroup(name);
            processBuilder.addDescription(description);
            processBuilder.addLabel(label);
            String roleMapperClassName = this.getChildTextContent(roleMapperElement, "classname");
            String roleMapperDescription = this.getChildTextContent(roleMapperElement, "description");
            processBuilder.addGroupResolver(roleMapperClassName);
            processBuilder.addDescription(roleMapperDescription);
            Element roleMapperParametersElement = XmlUtil.element(roleMapperElement, "parameters");
            List<Element> roleMapperParameterElements = XmlUtil.elements(roleMapperParametersElement, "parameter");
            if (roleMapperParameterElements == null) return null;
            for (Element roleMapperParameterElement : roleMapperParameterElements) {
                try {
                    String key = roleMapperParameterElement.getAttribute("name");
                    if (GroovyExpression.isGroovyExpression(key)) {
                        processBuilder.addOutputParameter(key, ((Object[])Misc.deserialize(Misc.base64DecodeAndGather(roleMapperParameterElement.getTextContent()), parse.getContextProperties()))[0].toString());
                        continue;
                    }
                    processBuilder.addInputParameter(key, (Object[])Misc.deserialize(Misc.base64DecodeAndGather(roleMapperParameterElement.getTextContent()), parse.getContextProperties()));
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException("Error while deserializing", e);
                    return null;
                }
            }
        }
        catch (Exception e) {
            parse.addProblem("Error parsing Participant " + name, e);
        }
        return null;
    }
}

