/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl.binding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.VariablePerformerAssign;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.parsing.xpdl.binding.MajorElementBinding;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyExpression;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class ActivityBinding
extends MajorElementBinding {
    private static final Logger LOG = Logger.getLogger(ActivityBinding.class.getName());

    public ActivityBinding() {
        super("Activity");
    }

    @Override
    public Object parse(Element activityElement, Parse parse, Parser parser) {
        Iterator<Element> i$;
        List<Element> transitionRestrictionElements;
        boolean route;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing element = " + activityElement);
        }
        String id = this.getId(activityElement);
        ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
        Collection activityDatafields = parse.findObject(Collection.class);
        String limit = this.getChildTextContent(activityElement, "Limit");
        if (limit != null) {
            parse.addProblem("'Limit' element not yet supported on activity definition.Please remove it from activity: " + id);
            if ("".equals(limit.trim())) {
                parse.addProblem("Limit definition incorrect: no value specified in element 'Limit' for activity: " + id);
            }
        }
        Element subFlowElement = null;
        boolean noImplementation = false;
        Element implementationElement = XmlUtil.element(activityElement, "Implementation");
        if (implementationElement != null) {
            noImplementation = XmlUtil.element(implementationElement, "No") != null;
            subFlowElement = XmlUtil.element(implementationElement, "SubFlow");
        }
        String startMode = "Automatic";
        Element startModeElement = XmlUtil.element(activityElement, "StartMode");
        if (startModeElement != null) {
            Element startModeFirstChildElement = XmlUtil.element(startModeElement);
            startMode = startModeFirstChildElement.getLocalName();
        }
        String finishMode = null;
        Element finishModeElement = XmlUtil.element(activityElement, "FinishMode");
        if (finishModeElement != null) {
            Element finishModeFirstChildElement = XmlUtil.element(finishModeElement);
            finishMode = finishModeFirstChildElement.getLocalName();
        } else {
            finishMode = "Automatic".equals(startMode) ? "Automatic" : "Manual";
        }
        String performer = this.getChildTextContent(activityElement, "Performer");
        this.checkStartAndFinishMode(startMode, finishMode, performer, id, noImplementation, parse);
        String priority = this.getChildTextContent(activityElement, "Priority");
        if (priority != null) {
            parse.addProblem("'Priority' element not yet supported on activity definition. Please remove it from activity: " + id);
        }
        boolean bl = route = XmlUtil.element(activityElement, "Route") != null;
        if (route) {
            processBuilder.addDecisionNode(id);
        } else if (subFlowElement != null) {
            Element actualparametersElement = XmlUtil.element(subFlowElement, "ActualParameters");
            if (actualparametersElement != null) {
                parse.addWarning("Subflow ActualParameters not yet supported.");
            }
            String subFlowId = XmlUtil.attribute(subFlowElement, "Id");
            String execution = XmlUtil.attribute(subFlowElement, "Execution");
            if (execution != null && "Asyncr".equals(execution)) {
                parse.addProblem("Asyncr SubFlow is not supported");
            }
            processBuilder.addSubProcess(id, subFlowId);
        } else if ("Manual".equals(startMode)) {
            processBuilder.addHumanTask(id, performer);
        } else {
            processBuilder.addSystemTask(id);
        }
        String description = this.getChildTextContent(activityElement, "Description");
        processBuilder.addDescription(description);
        processBuilder.addLabel(XmlUtil.attribute(activityElement, "Name"));
        boolean isAsync = false;
        Element asyncElement = this.getExtendedAttribute(activityElement, "Async");
        if (asyncElement != null) {
            isAsync = Boolean.valueOf(XmlUtil.attribute(asyncElement, "Value"));
        }
        if (isAsync) {
            processBuilder.asynchronous();
        }
        this.parseDeadlines(activityElement, parse, processBuilder);
        ActivityDefinition.SplitType splitType = null;
        ActivityDefinition.JoinType joinType = ActivityDefinition.JoinType.AND;
        Element transitionRestrictionsElement = XmlUtil.element(activityElement, "TransitionRestrictions");
        if (transitionRestrictionsElement != null && (transitionRestrictionElements = XmlUtil.elements(transitionRestrictionsElement, "TransitionRestriction")) != null && (i$ = transitionRestrictionElements.iterator()).hasNext()) {
            Element splitElement;
            Element transitionrestrictionElement = i$.next();
            Element joinElement = XmlUtil.element(transitionrestrictionElement, "Join");
            if (joinElement != null && (joinType = (ActivityDefinition.JoinType)this.getEnumValue(ActivityDefinition.JoinType.class, XmlUtil.attribute(joinElement, "Type"), null)) == null) {
                parse.addProblem("Mandatory type attribute is not specified on join element");
            }
            if ((splitElement = XmlUtil.element(transitionrestrictionElement, "Split")) != null) {
                splitType = this.getEnumValue(ActivityDefinition.SplitType.class, XmlUtil.attribute(splitElement, "Type"), null);
                if (splitType == null) {
                    parse.addProblem("Mandatory type attribute is not specified on Split element!");
                }
                processBuilder.addSplitType(splitType);
            }
        }
        processBuilder.addJoinType(joinType);
        boolean isAutomaticActivity = "Automatic".equals(startMode);
        this.parseHooks(activityElement, parse, isAutomaticActivity, processBuilder);
        this.parsePerformerAssign(activityElement, parse, processBuilder);
        this.parseDataFields(activityElement, parse, processBuilder, activityDatafields, parser);
        this.parseMultiInstantiationDefinition(activityElement, parse, route, processBuilder);
        return null;
    }

    private void parseMultiInstantiationDefinition(Element activityElement, Parse parse, boolean isRoute, ProcessBuilder processuilder) {
        Element activityInstantiatorElement = this.getExtendedAttribute(activityElement, "MultiInstantiation");
        if (activityInstantiatorElement != null) {
            String variableId;
            String className = this.getChildTextContent(activityInstantiatorElement, "MultiInstantiator");
            if (className == null) {
                parse.addProblem("MultiInstantiation needs to specify a MultiInstantiator class name (in a nested MultiInstantiator element)");
            }
            if ((variableId = this.getChildTextContent(activityInstantiatorElement, "Variable")) == null) {
                parse.addProblem("MultiInstantiation needs to specify a variable id (in a nested Variable element)");
            }
            if (className != null && variableId != null) {
                if (isRoute) {
                    parse.addProblem("Multi Instantiation cannot be defined on a Route activity");
                } else {
                    processuilder.addMultiInstanciation(variableId, className);
                }
            }
        }
    }

    protected void parsePerformerAssign(Element activityElement, Parse parse, ProcessBuilder processBuilder) {
        Element performerAssignElement = this.getExtendedAttribute(activityElement, "PerformerAssign");
        if (performerAssignElement != null) {
            Element callbackElement;
            String value = XmlUtil.attribute(performerAssignElement, "Value");
            String className = null;
            HashMap<String, Object[]> parameters = null;
            if ("Callback".equals(value)) {
                callbackElement = XmlUtil.element(performerAssignElement, "Callback");
                className = callbackElement.getTextContent();
            } else if ("Custom".equals(value)) {
                callbackElement = XmlUtil.element(performerAssignElement, "Custom");
                className = callbackElement.getTextContent();
            } else if ("Variable".equals(value)) {
                Element propertyElement = XmlUtil.element(performerAssignElement, "Variable");
                parameters = new HashMap<String, Object[]>();
                parameters.put("variableId", new Object[]{propertyElement.getTextContent()});
                className = VariablePerformerAssign.class.getName();
            } else {
                parse.addProblem("Unsupported value on extendedAttribute PerformerAssign: " + value);
            }
            processBuilder.addFilter(className);
            if (parameters != null) {
                for (Map.Entry parameter : parameters.entrySet()) {
                    String key = (String)parameter.getKey();
                    if (GroovyExpression.isGroovyExpression(key)) {
                        processBuilder.addOutputParameter(key, (String)((Object[])parameter.getValue())[0]);
                        continue;
                    }
                    processBuilder.addInputParameter(key, (Object[])parameter.getValue());
                }
            }
        }
    }

    private void checkStartAndFinishMode(String startMode, String finishMode, String performer, String activityId, boolean isNoImpl, Parse parse) {
        boolean hasManualMode;
        if ("Manual".equals(finishMode) && "Automatic".equals(startMode) || "Automatic".equals(finishMode) && "Manual".equals(startMode)) {
            parse.addProblem("StartMode and FinishMode have different values: this feature is not yet supported.");
        }
        boolean bl = hasManualMode = "Manual".equals(startMode) || "Manual".equals(finishMode);
        if (hasManualMode) {
            if (performer == null) {
                parse.addProblem("StartMode or FinishMode is Manual and no performer is specified on activity processDefinitionUUID = " + activityId + "! Please specify one.");
            }
            if (!isNoImpl) {
                parse.addProblem("StartMode or FinishMode is Manual and activity implementation is not No:this feature is not yet supported.");
            }
        }
    }

    protected void parseDataFields(Element activityElement, Parse parse, ProcessBuilder processBuilder, Collection<Element> activityDatafields, Parser parser) {
        Set<Element> propertyElements = this.getExtendedAttributes(activityElement, "property");
        if (propertyElements != null && !propertyElements.isEmpty()) {
            if (activityDatafields == null) {
                parse.addProblem("No activity dataFields is defined within the process.");
            } else {
                for (Element propertyElement : propertyElements) {
                    String propagatedValue;
                    String dataFieldId = XmlUtil.attribute(propertyElement, "Value");
                    boolean found = false;
                    for (Element datafieldElement : activityDatafields) {
                        String id = this.getId(datafieldElement);
                        if (!id.equals(dataFieldId)) continue;
                        parser.parseElement(datafieldElement, parse, "majorElements");
                        found = true;
                        break;
                    }
                    if (!found) {
                        parse.addProblem("Looking for a datafield with id: " + dataFieldId + " in enclosing process but unable to find it.");
                    }
                    if ((propagatedValue = this.getChildTextContent(propertyElement, "Propagated")) == null || "no".equalsIgnoreCase(propagatedValue) || "false".equalsIgnoreCase(propagatedValue)) continue;
                    parse.addProblem("Propagated value not supported: " + propagatedValue + ". Use instance variables instead." + "(Only 'no' or 'false' are supported for backward compatibility.)");
                }
            }
        }
    }

    protected void parseHooks(Element activityElement, Parse parse, boolean isAutomatic, ProcessBuilder processBuilder) {
        Set<Element> hookElements = this.getExtendedAttributes(activityElement, "hook");
        if (hookElements != null) {
            for (Element hookElement : hookElements) {
                String className = XmlUtil.attribute(hookElement, "Value");
                String hookEventName = this.getChildTextContent(hookElement, "HookEventName");
                Map<String, Object[]> parameters = this.getHookParameters(hookElement, parse, className);
                if (hookEventName == null) {
                    parse.addProblem("hook ExtendedAttribute needs an element child called HookEventName");
                    return;
                }
                HookDefinition.Event event = null;
                boolean throwingException = false;
                String rollBackFlag = this.getChildTextContent(hookElement, "Rollback");
                throwingException = false;
                if ("true".equals(rollBackFlag)) {
                    throwingException = true;
                }
                try {
                    event = this.getEventFromString(hookEventName);
                }
                catch (IllegalArgumentException iae) {
                    parse.addProblem("Unsupported HookEventName: " + hookEventName + " for " + (isAutomatic ? "automatic" : "manual") + " activity.");
                }
                if (event == null) continue;
                processBuilder.addConnector(event, className, throwingException);
                if (parameters == null) continue;
                for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                    String key = parameter.getKey();
                    if (GroovyExpression.isGroovyExpression(key)) {
                        processBuilder.addOutputParameter(key, (String)parameter.getValue()[0]);
                        continue;
                    }
                    processBuilder.addInputParameter(key, parameter.getValue());
                }
            }
        }
    }

    private HookDefinition.Event getEventFromString(String hookEventName) {
        if ("task:onReady".equals(hookEventName)) {
            return HookDefinition.Event.taskOnReady;
        }
        if ("task:onStart".equals(hookEventName)) {
            return HookDefinition.Event.taskOnStart;
        }
        if ("task:onFinish".equals(hookEventName)) {
            return HookDefinition.Event.taskOnFinish;
        }
        if ("task:onSuspend".equals(hookEventName)) {
            return HookDefinition.Event.taskOnSuspend;
        }
        if ("task:onResume".equals(hookEventName)) {
            return HookDefinition.Event.taskOnResume;
        }
        if ("task:onCancel".equals(hookEventName)) {
            return HookDefinition.Event.taskOnCancel;
        }
        if ("automatic:onEnter".equals(hookEventName)) {
            return HookDefinition.Event.automaticOnEnter;
        }
        String message = ExceptionManager.getInstance().getFullMessage("buc_M_11", HookDefinition.Event.class.getName(), hookEventName);
        throw new IllegalArgumentException(message);
    }

    private Map<String, Object[]> getHookParameters(Element hookElement, Parse parse, String className) {
        HashMap<String, Object[]> hookParameters = new HashMap<String, Object[]>();
        Element hookParametersElement = XmlUtil.element(hookElement, "Parameters");
        if (hookParametersElement != null) {
            List<Element> parameters = XmlUtil.elements(hookParametersElement);
            for (Element param : parameters) {
                String method;
                String paramType = param.getLocalName();
                String variable = param.getAttribute("Var");
                if ("InParameter".equals(paramType)) {
                    if (param.hasAttribute("Setter")) {
                        method = param.getAttribute("Setter");
                        if (method.length() != 0) {
                            hookParameters.put(method, new Object[]{variable});
                            continue;
                        }
                        parse.addProblem("The Setter attribute should not be empty!");
                        continue;
                    }
                    parse.addProblem("InParameter need the Setter attribute");
                    continue;
                }
                if ("OutParameter".equals(paramType)) {
                    if (param.hasAttribute("Getter")) {
                        method = param.getAttribute("Getter");
                        if (method.length() != 0) {
                            hookParameters.put(method, new Object[]{variable});
                            continue;
                        }
                        parse.addProblem("The Getter attribute should not be empty!");
                        continue;
                    }
                    parse.addProblem("OutParameter need the Getter attribute");
                    continue;
                }
                if (!"Properties".equals(paramType)) continue;
                if (variable.startsWith("file:")) {
                    hookParameters.put("file:", new Object[]{variable.substring(5)});
                    continue;
                }
                if (variable.startsWith("bar:")) {
                    hookParameters.put("bar:", new Object[]{variable.substring(4)});
                    continue;
                }
                if (variable.startsWith("resource:")) {
                    hookParameters.put("resource:", new Object[]{variable.substring(9)});
                    continue;
                }
                parse.addProblem("The value of Var attribute can only be either file:<absolute_file_path> or bar:<file_path_in_bar_file> orresource:<resource_path>");
            }
        }
        return hookParameters;
    }

    protected void parseDeadlines(Element activityElement, Parse parse, ProcessBuilder processBuilder) {
        List<Element> deadlineElements = XmlUtil.elements(activityElement, "Deadline");
        if (deadlineElements != null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Bonita use of deadlines is specific: refer to bonita User Guide for more details");
            }
            for (Element deadlineElement : deadlineElements) {
                String exceptionName;
                String deadlineCondition = this.getChildTextContent(deadlineElement, "DeadlineCondition");
                if (deadlineCondition == null || "".equals(deadlineCondition)) {
                    parse.addProblem("DeadlineCondition element is not specified on deadline element");
                }
                if ((exceptionName = this.getChildTextContent(deadlineElement, "ExceptionName")) == null) {
                    parse.addProblem("ExceptionName element is not specified on deadline element");
                }
                processBuilder.addDeadline(deadlineCondition, exceptionName);
            }
        }
    }
}

