/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.parsing.xpdl.binding;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.parsing.xpdl.binding.MajorElementBinding;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class DataFieldBinding
extends MajorElementBinding {
    private static final Logger LOG = Logger.getLogger(DataFieldBinding.class.getName());
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};

    public DataFieldBinding() {
        super("DataField");
    }

    @Override
    public Object parse(Element datafieldElement, Parse parse, Parser parser) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("parsing element = " + datafieldElement);
        }
        Boolean isParsingActivity = parse.findObject(Boolean.class);
        String name = this.getId(datafieldElement);
        for (String javaKeyword : JAVA_KEYWORDS) {
            if (!javaKeyword.equals(name)) continue;
            parse.addProblem("A datafield is declared with id : " + name + ", it is forbidden as it is a java Keyword");
        }
        boolean activityDatafield = this.containsExtendedAttribute(datafieldElement, "PropertyActivity");
        if (activityDatafield && !datafieldElement.getParentNode().getParentNode().getLocalName().equals("WorkflowProcess")) {
            parse.addProblem("A datafield with process id = " + name + " defined at package level is expected to be an 'activity datafield' as it declares " + "the corresponding extended attribute: it is forbiden. " + "'Activity datafields' can only be defined at process level.");
        }
        if (activityDatafield && isParsingActivity == null) {
            return datafieldElement;
        }
        String description = this.getChildTextContent(datafieldElement, "Description");
        String initialValue = this.getChildTextContent(datafieldElement, "InitialValue");
        String length = this.getChildTextContent(datafieldElement, "Length");
        if (length != null) {
            parse.addProblem("Length element not yet supported on element DataField, processDefinitionUUID = " + name);
        }
        boolean array = false;
        String isArray = XmlUtil.attribute(datafieldElement, "IsArray");
        if (isArray != null && (array = Boolean.valueOf(isArray).booleanValue())) {
            parse.addProblem("isArray=true not yet supported on element DataField.");
        }
        ProcessBuilder processBuilder = parse.findObject(ProcessBuilder.class);
        this.addData(datafieldElement, name, initialValue, processBuilder, parse);
        processBuilder.addDescription(description);
        processBuilder.addLabel(XmlUtil.attribute(datafieldElement, "Name"));
        return null;
    }
}

