/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.IllegalTaskStateException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.TransientData;

public class ActivityManager {
    private static final Logger LOG = Logger.getLogger(ActivityManager.class.getName());

    protected static ActivityInstance getActivity(ActivityInstanceUUID activityUUID) throws ActivityNotFoundException {
        InternalActivityInstance activityInstance = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
        if (activityInstance == null) {
            throw new ActivityNotFoundException("bai_RAPII_19", activityUUID);
        }
        return activityInstance;
    }

    protected static Execution getExecution(ActivityInstance activityInstance) throws ActivityNotFoundException {
        return EnvTool.getJournalQueriers().getExecutionOnActivity(activityInstance.getProcessInstanceUUID(), activityInstance.getUUID());
    }

    public static void skip(ActivityInstanceUUID activityInstanceUUID, Map<String, Object> variablesToUpdate) throws ActivityNotFoundException, IllegalTaskStateException {
        ActivityInstance activityInstance = ActivityManager.getActivity(activityInstanceUUID);
        Execution internalExecution = ActivityManager.getExecution(activityInstance);
        ActivityManager.skip(internalExecution, activityInstance, variablesToUpdate);
    }

    protected static void skip(Execution internalExecution, ActivityInstance activityInstance, Map<String, Object> variablesToUpdate) throws IllegalTaskStateException {
        ActivityInstanceUUID activityInstanceUUID;
        block11: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Checking compatible state of " + activityInstance);
            }
            activityInstanceUUID = activityInstance.getUUID();
            ActivityState state = activityInstance.getState();
            if (!state.equals((Object)ActivityState.READY) && !state.equals((Object)ActivityState.FAILED)) {
                HashSet<ActivityState> expectedStates = new HashSet<ActivityState>();
                expectedStates.add(ActivityState.READY);
                expectedStates.add(ActivityState.FAILED);
                String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_13", new Object[0]);
                throw new IllegalTaskStateException("bai_RAPII_13", message, activityInstanceUUID, expectedStates, state);
            }
            if (variablesToUpdate != null && !variablesToUpdate.isEmpty()) {
                try {
                    for (Map.Entry<String, Object> entry : variablesToUpdate.entrySet()) {
                        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                        accessor.getRuntimeAPI().setVariable(activityInstanceUUID, entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block11;
                    LOG.severe("Error while setting the variable on skip task : " + activityInstance.getActivityName() + ". Exception: " + Misc.getStackTraceFrom(e));
                }
            }
        }
        String currentUserId = EnvTool.getUserId();
        String activityName = activityInstance.getActivityName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Skiping activity : " + activityInstanceUUID + " on activity " + activityName);
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordActivitySkipped(activityInstance, currentUserId);
        TransientData.removeTransientData(activityInstanceUUID);
        Set<InternalActivityInstance> activities = EnvTool.getJournalQueriers().getActivityInstances(activityInstance.getProcessInstanceUUID(), activityName);
        if (activities.size() > 1) {
            for (InternalActivityInstance currentActivity : activities) {
                if (!ActivityState.READY.equals((Object)currentActivity.getState()) && !ActivityState.FAILED.equals((Object)currentActivity.getState()) || activityInstanceUUID.equals(currentActivity.getUUID())) continue;
                recorder.recordActivitySkipped(currentActivity, currentUserId);
                TransientData.removeTransientData(activityInstanceUUID);
            }
        }
        InternalActivityDefinition activityDef = internalExecution.getNode();
        AbstractActivity abstractActivity = (AbstractActivity)activityDef.getBehaviour();
        if (!ActivityState.ABORTED.equals((Object)internalExecution.getActivityInstance().getState())) {
            abstractActivity.signal(internalExecution, "bodySkipped", null);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Skipped: " + activityInstance);
            }
        }
    }
}

