/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.AssertionFailure;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.bonita.connector.core.Filter;
import org.ow2.bonita.connector.core.PerformerAssignFilter;
import org.ow2.bonita.definition.PerformerAssign;
import org.ow2.bonita.definition.RoleMapper;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.FilterDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.RoleMapperDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.BonitaWrapperException;
import org.ow2.bonita.facade.exception.IllegalTaskStateException;
import org.ow2.bonita.facade.exception.RoleMapperInvocationException;
import org.ow2.bonita.facade.exception.TaskNotFoundException;
import org.ow2.bonita.facade.exception.UnRollbackableException;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.runtime.ActivityManager;
import org.ow2.bonita.runtime.ExtensionPointsPolicy;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.TransientData;

public class TaskManager {
    private static final Logger LOG = Logger.getLogger(TaskManager.class.getName());

    private static TaskInstance getTask(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance task = EnvTool.getJournalQueriers().getTaskInstance(taskUUID);
        if (task == null) {
            throw new TaskNotFoundException("bai_RAPII_19", taskUUID);
        }
        return task;
    }

    private static ActivityDefinition getActivityDefinition(ProcessDefinitionUUID processUUID, String activityName) {
        InternalActivityDefinition activity = EnvTool.getJournalQueriers().getActivity(new ActivityDefinitionUUID(processUUID, activityName));
        return activity;
    }

    protected static Execution getExecution(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        return EnvTool.getJournalQueriers().getExecutionOnActivity(task.getProcessInstanceUUID(), taskUUID);
    }

    private static void assign(ActivityInstance task, Set<String> candidates, String userId) {
        ActivityInstanceUUID taskUUID = task.getUUID();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("assigning task : " + taskUUID + " on activity " + task.getActivityName());
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordTaskAssigned(taskUUID, task.getState(), EnvTool.getUserId(), candidates, userId);
    }

    public static void unAssign(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unassigning: " + task);
        }
        TaskManager.assign(task, task.getTaskCandidates(), null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unassigned: " + task);
        }
    }

    public static void assign(ActivityInstanceUUID taskUUID, Set<String> candidates) throws TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigning: " + task);
        }
        TaskManager.assign(task, candidates, null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigned: " + task);
        }
    }

    public static void assign(ActivityInstanceUUID taskUUID, String userId) throws TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigning: " + task + " to " + userId);
        }
        TaskManager.assign(task, null, userId);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigned: " + task + " to " + userId);
        }
    }

    private static Set<String> getCandidates(Set<Performer> performers, TaskInstance task) {
        HashSet<String> candidates = null;
        if (performers != null) {
            candidates = new HashSet<String>();
            for (Performer performer : performers) {
                Set<String> tmp;
                if (performer.isHuman()) {
                    candidates.add(performer.getName());
                    continue;
                }
                if (performer.getRoleMapperDefinition() == null || (tmp = TaskManager.executeRoleMapper(task, performer)) == null) continue;
                candidates.addAll(tmp);
            }
        }
        return candidates;
    }

    public static void assign(ActivityInstanceUUID taskUUID) throws TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        ProcessDefinitionUUID processUUID = task.getProcessDefinitionUUID();
        ActivityDefinition activityDefinition = TaskManager.getActivityDefinition(processUUID, task.getActivityName());
        Set<Performer> performers = TaskManager.getPerformers(activityDefinition);
        Set<String> candidates = TaskManager.getCandidates(performers, task);
        String userId = null;
        Performer performer = performers.iterator().next();
        if (performer.getFilterDefinition() != null && (candidates = TaskManager.executeFilter(task, candidates, performer)).size() == 1) {
            userId = candidates.iterator().next();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigning: " + task);
        }
        if (userId != null) {
            TaskManager.assign(task, null, userId);
        } else {
            TaskManager.assign(task, candidates, null);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Assigned: " + task);
        }
    }

    public static void finish(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (!ActivityState.ABORTED.equals((Object)task.getState()) && !ActivityState.FAILED.equals((Object)task.getState())) {
            AbstractActivity abstractActivity;
            Execution internalExecution;
            block13: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Checking compatible state of " + task);
                }
                if (!task.getState().equals((Object)ActivityState.EXECUTING)) {
                    HashSet<ActivityState> expectedStates = new HashSet<ActivityState>();
                    expectedStates.add(ActivityState.EXECUTING);
                    String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_11", new Object[0]);
                    throw new IllegalTaskStateException("bai_RAPII_11", message, taskUUID, expectedStates, task.getState());
                }
                String activityName = task.getActivityName();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Finishing task : " + taskUUID + " on activity " + activityName);
                }
                Recorder recorder = EnvTool.getRecorder();
                if (assignTask) {
                    TaskManager.assign(task, null, task.getTaskUser());
                }
                recorder.recordTaskFinished(taskUUID, EnvTool.getUserId());
                internalExecution = TaskManager.getExecution(taskUUID);
                InternalActivityDefinition activityDef = internalExecution.getNode();
                abstractActivity = (AbstractActivity)activityDef.getBehaviour();
                try {
                    ConnectorExecutor.executeConnectors(activityDef, internalExecution, HookDefinition.Event.taskOnFinish);
                }
                catch (StaleStateException sse) {
                    throw sse;
                }
                catch (AssertionFailure af) {
                    throw af;
                }
                catch (LockAcquisitionException lae) {
                    throw lae;
                }
                catch (RuntimeException e) {
                    recorder.recordActivityFailed(task);
                    if (!ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) break block13;
                    TransientData.removeTransientData(taskUUID);
                    throw new UnRollbackableException("Error while executing connector taskOnFinish", e);
                }
            }
            ActivityState activityState = internalExecution.getActivityInstance().getState();
            if (!ActivityState.ABORTED.equals((Object)activityState) && !ActivityState.FAILED.equals((Object)activityState)) {
                abstractActivity.signal(internalExecution, "bodyFinished", null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Terminated: " + task);
                }
            } else {
                TransientData.removeTransientData(taskUUID);
            }
        }
    }

    public static void suspend(ActivityInstanceUUID taskUUID, boolean assignTask) throws TaskNotFoundException, IllegalTaskStateException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Checking compatible state of " + task);
        }
        if (!task.getState().equals((Object)ActivityState.READY) && !task.getState().equals((Object)ActivityState.EXECUTING)) {
            HashSet<ActivityState> expectedStates = new HashSet<ActivityState>();
            expectedStates.add(ActivityState.READY);
            expectedStates.add(ActivityState.EXECUTING);
            String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_13", new Object[0]);
            throw new IllegalTaskStateException("bai_RAPII_13", message, taskUUID, expectedStates, task.getState());
        }
        String currentUserId = EnvTool.getUserId();
        ProcessDefinitionUUID processUUID = task.getProcessDefinitionUUID();
        String activityName = task.getActivityName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Suspending task : " + taskUUID + " on activity " + activityName);
        }
        Recorder recorder = EnvTool.getRecorder();
        if (assignTask) {
            TaskManager.assign(task, null, currentUserId);
        }
        recorder.recordTaskSuspended(taskUUID, EnvTool.getUserId());
        Execution internalExecution = TaskManager.getExecution(taskUUID);
        ActivityDefinition activityDef = TaskManager.getActivityDefinition(processUUID, activityName);
        ConnectorExecutor.executeConnectors(activityDef, internalExecution, HookDefinition.Event.taskOnSuspend);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Suspended: " + task);
        }
    }

    public static void resume(ActivityInstanceUUID taskUUID, boolean taskAssign) throws IllegalTaskStateException, TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Checking compatible state of " + task);
        }
        if (!task.getState().equals((Object)ActivityState.SUSPENDED)) {
            HashSet<ActivityState> expectedStates = new HashSet<ActivityState>();
            expectedStates.add(ActivityState.SUSPENDED);
            String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_15", new Object[0]);
            throw new IllegalTaskStateException("bai_RAPII_15", message, taskUUID, expectedStates, task.getState());
        }
        String currentUserId = EnvTool.getUserId();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Resuming: " + task);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Resuming task : " + taskUUID + " on activity " + task.getActivityName());
        }
        Recorder recorder = EnvTool.getRecorder();
        if (taskAssign) {
            TaskManager.assign(task, null, currentUserId);
        }
        recorder.recordTaskResumed(taskUUID, EnvTool.getUserId());
        Execution internalExecution = TaskManager.getExecution(taskUUID);
        InternalActivityDefinition activityDef = internalExecution.getNode();
        ConnectorExecutor.executeConnectors(activityDef, internalExecution, HookDefinition.Event.taskOnResume);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Resumed: " + task);
        }
    }

    public static void start(ActivityInstanceUUID taskUUID, boolean assignTask) throws IllegalTaskStateException, TaskNotFoundException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        if (!ActivityState.ABORTED.equals((Object)task.getState())) {
            block11: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Checking compatible state of " + task);
                }
                if (!task.getState().equals((Object)ActivityState.READY)) {
                    HashSet<ActivityState> expectedStates = new HashSet<ActivityState>();
                    expectedStates.add(ActivityState.READY);
                    String message = ExceptionManager.getInstance().getFullMessage("bai_RAPII_9", new Object[0]);
                    throw new IllegalTaskStateException("bai_RAPII_9", message, taskUUID, expectedStates, task.getState());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Starting: " + task);
                }
                Recorder recorder = EnvTool.getRecorder();
                if (assignTask) {
                    TaskManager.assign(task, null, EnvTool.getUserId());
                }
                Execution internalExecution = TaskManager.getExecution(taskUUID);
                recorder.recordBodyStarted(task);
                recorder.recordTaskStarted(taskUUID, EnvTool.getUserId());
                InternalActivityDefinition activityDef = internalExecution.getNode();
                try {
                    ConnectorExecutor.executeConnectors(activityDef, internalExecution, HookDefinition.Event.taskOnStart);
                }
                catch (StaleStateException sse) {
                    throw sse;
                }
                catch (AssertionFailure af) {
                    throw af;
                }
                catch (LockAcquisitionException lae) {
                    throw lae;
                }
                catch (RuntimeException e) {
                    recorder.recordActivityFailed(task);
                    if (!ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) break block11;
                    throw new UnRollbackableException("Error while executing connector taskOnStart", e);
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Started: " + task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> executeFilter(TaskInstance task, Set<String> candidates, Performer performer) {
        ProcessDefinitionUUID processUUID = task.getProcessDefinitionUUID();
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            FilterDefinition filterDefinition = performer.getFilterDefinition();
            if (filterDefinition != null) {
                PerformerAssign performerAssign = TaskManager.getPerformerAssign(processUUID, filterDefinition);
                Filter filter = null;
                filter = performerAssign == null ? EnvTool.getClassDataLoader().getInstance(Filter.class, processUUID, filterDefinition) : new PerformerAssignFilter();
                try {
                    Set<String> set = ConnectorExecutor.executeFilter(filter, performerAssign, task, candidates, filterDefinition.getParameters());
                    return set;
                }
                catch (Exception e) {
                    throw new BonitaWrapperException(e);
                }
            }
            Set<String> set = candidates;
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    private static PerformerAssign getPerformerAssign(ProcessDefinitionUUID processUUID, FilterDefinition filterDefinition) {
        try {
            return EnvTool.getClassDataLoader().getInstance(PerformerAssign.class, processUUID, filterDefinition);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> executeRoleMapper(TaskInstance task, Performer performer) {
        ProcessDefinitionUUID processUUID = task.getProcessDefinitionUUID();
        RoleMapperDefinition rolemapperDef = performer.getRoleMapperDefinition();
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
            Thread.currentThread().setContextClassLoader(processClassLoader);
            if (rolemapperDef != null) {
                RoleMapper roleMapper = EnvTool.getClassDataLoader().getInstance(RoleMapper.class, processUUID, rolemapperDef);
                try {
                    Set<String> set = ConnectorExecutor.executeRoleMapper(roleMapper, task, performer.getName(), rolemapperDef.getParameters());
                    return set;
                }
                catch (Exception e) {
                    throw new BonitaWrapperException(new RoleMapperInvocationException("be_TRT_2", rolemapperDef.toString(), e));
                }
            }
            Set<String> set = null;
            return set;
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    public static void ready(Execution internalExecution) throws TaskNotFoundException {
        ActivityInstanceUUID taskUUID = new ActivityInstanceUUID(internalExecution.getActivityInstanceUUID().toString());
        InternalActivityDefinition activityDef = internalExecution.getNode();
        TaskInstance task = TaskManager.getTask(taskUUID);
        String activityName = task.getActivityName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Ready task : " + taskUUID + " on activity " + activityName);
        }
        Set<Performer> performers = TaskManager.getPerformers(activityDef);
        String userId = null;
        Set<String> candidates = null;
        if (performers != null) {
            candidates = TaskManager.getCandidates(performers, task);
            Performer performer = performers.iterator().next();
            if (performer.getFilterDefinition() != null && (candidates = TaskManager.executeFilter(task, candidates, performer)).size() == 1) {
                userId = candidates.iterator().next();
            }
        }
        if (userId != null) {
            EnvTool.getRecorder().recordTaskReady(taskUUID, null, userId);
        } else {
            EnvTool.getRecorder().recordTaskReady(taskUUID, candidates, null);
        }
        ConnectorExecutor.executeConnectors(activityDef, internalExecution, HookDefinition.Event.taskOnReady);
    }

    protected static Performer getPerformer(ActivityDefinition activity, ProcessDefinition processDef, String performer) {
        ParticipantDefinition participant = null;
        if (processDef.getParticipants() != null) {
            for (ParticipantDefinition p : processDef.getParticipants()) {
                if (!p.getName().equals(performer)) continue;
                participant = p;
                break;
            }
        }
        if (participant == null) {
            throw new BonitaRuntimeException("Wrong performer: " + performer + ". No participant is defined within the process with processDefinitionUUID: " + performer);
        }
        return new Performer(performer, participant.getRoleMapper(), activity.getFilter());
    }

    private static Set<Performer> getPerformers(ActivityDefinition activityDefinition) {
        Set<String> performers = activityDefinition.getPerformers();
        HashSet<Performer> result = null;
        if (!performers.isEmpty()) {
            InternalProcessDefinition processDef = EnvTool.getJournalQueriers().getProcess(activityDefinition.getProcessDefinitionUUID());
            result = new HashSet<Performer>();
            for (String performer : performers) {
                result.add(TaskManager.getPerformer(activityDefinition, processDef, performer));
            }
        }
        return result;
    }

    public static void skip(ActivityInstanceUUID taskUUID, Map<String, Object> variablesToUpdate) throws TaskNotFoundException, IllegalTaskStateException {
        TaskInstance task = TaskManager.getTask(taskUUID);
        Execution internalExecution = TaskManager.getExecution(taskUUID);
        ActivityManager.skip(internalExecution, task, variablesToUpdate);
    }

    private static class Performer {
        protected String name;
        protected RoleMapperDefinition roleMapper;
        protected FilterDefinition filter;

        public Performer(String name, RoleMapperDefinition roleMapper, FilterDefinition filter) {
            this.name = name;
            this.roleMapper = roleMapper;
            this.filter = filter;
        }

        public RoleMapperDefinition getRoleMapperDefinition() {
            return this.roleMapper;
        }

        public FilterDefinition getFilterDefinition() {
            return this.filter;
        }

        public String getName() {
            return this.name;
        }

        public boolean isHuman() {
            return this.roleMapper == null && this.filter == null;
        }
    }
}

