/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class CreateJob
implements Command<Void> {
    private static final long serialVersionUID = -803942547334112806L;
    private final EventCoupleId eventCoupleId;

    public CreateJob(EventCoupleId eventCoupleId) {
        this.eventCoupleId = eventCoupleId;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        IncomingEventInstance ie = eventService.getIncomingEvent(this.eventCoupleId.getIncoming());
        OutgoingEventInstance oe = eventService.getOutgoingEvent(this.eventCoupleId.getOutgoing());
        String eventPosition = null;
        String event = ie.getSignal();
        if (event.contains("start")) {
            eventPosition = "start";
        } else if (event.contains("boundary")) {
            eventPosition = "boundary";
        } else if (event.contains("intermediate")) {
            eventPosition = "intermediate";
        }
        ProcessInstanceUUID instanceUUID = ie.getInstanceUUID();
        ProcessInstanceUUID rootInstanceUUID = null;
        if (instanceUUID != null) {
            InternalProcessInstance instance = EnvTool.getJournal().getProcessInstance(instanceUUID);
            rootInstanceUUID = instance.getRootInstanceUUID();
        }
        Job job = new Job(ie.getName(), eventPosition, "message", rootInstanceUUID, ie.getExecutionUUID(), ie.getActivityDefinitionUUID(), null, System.currentTimeMillis(), instanceUUID);
        job.setEventSubProcessRootInstanceUUID(ie.getEventSubProcessRootInstanceUUID());
        if (!"start".equals(job.getEventPosition())) {
            eventService.removeEvent(ie);
        } else {
            ie.unlock();
        }
        if (oe.getParameters().isEmpty()) {
            eventService.removeEvent(oe);
        } else {
            job.setOutgoingEvent(oe);
        }
        eventService.storeJob(job);
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateJob [eventCoupleId=");
        builder.append(this.eventCoupleId);
        builder.append("]");
        return builder.toString();
    }
}

