/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.AssertionFailure;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobBuilder;
import org.ow2.bonita.runtime.event.JobExceptionHandler;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.ProcessUtil;

public class ExecuteJob
implements Command<Void> {
    private static final Logger LOG = Logger.getLogger(ExecuteJob.class.getName());
    private static final long serialVersionUID = -479276850307735480L;
    private final Long jobId;
    private final EventExecutor jobExecutor;

    public ExecuteJob(Long jobId, EventExecutor jobExecutor) {
        this.jobId = jobId;
        this.jobExecutor = jobExecutor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        Job job = eventService.getJob(this.jobId);
        if (job != null) {
            String eventPosition = job.getEventPosition();
            try {
                if ("start".equals(eventPosition)) {
                    this.instantiateStartEvent(job);
                    return null;
                }
                if ("boundary".equals(eventPosition) || "execCnnctAut".equals(eventPosition) || "sigCnnctAutEnd".equals(eventPosition)) {
                    this.handleJobsWithExecution(job);
                    return null;
                }
                this.executeEvent(job);
                return null;
            }
            catch (StaleStateException sse) {
                throw sse;
            }
            catch (AssertionFailure af) {
                throw af;
            }
            catch (LockAcquisitionException lae) {
                throw lae;
            }
            catch (Throwable exception) {
                String executionUUID = job.getExecutionUUID();
                if (job.getRetries() == 1 && executionUUID != null) {
                    Execution execution = EnvTool.getJournal().getExecutionWithEventUUID(executionUUID);
                    InternalActivityInstance activityInstance = execution.getActivityInstance();
                    Recorder recorder = EnvTool.getRecorder();
                    recorder.recordActivityFailed(activityInstance);
                    if (!LOG.isLoggable(Level.SEVERE)) return null;
                    LOG.severe("The activity \"" + activityInstance.getUUID() + "\" is in the state FAILED because an exception caught while executing job: " + exception + ". Exception: " + exception.getMessage());
                    return null;
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Exception caught while executing job: " + exception + ". Exception: " + exception.getMessage());
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("handling job: " + job + " exception: " + exception.getMessage());
                }
                this.handleException(environment, job, exception);
                return null;
            }
        } else {
            if (!LOG.isLoggable(Level.WARNING)) return null;
            LOG.warning("Unable to found job: " + this.jobId + ". It was probably delete by another transaction (process instance finished, deleted...)");
        }
        return null;
    }

    private void instantiateStartEvent(Job job) throws GroovyException, ProcessNotFoundException, InstanceNotFoundException {
        EventService eventService = EnvTool.getEventService();
        InternalActivityDefinition activity = EnvTool.getJournal().getActivity(job.getActivityDefinitionUUID());
        ProcessDefinitionUUID processUUID = activity.getProcessDefinitionUUID();
        Authentication.setUserId("SYSTEM");
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtimeAPI = accessor.getRuntimeAPI();
        ProcessInstanceUUID eventSubProcessRootInstanceUUID = job.getEventSubProcessRootInstanceUUID();
        if (eventSubProcessRootInstanceUUID != null) {
            this.instantiateStartEventSubProcess(job);
        } else {
            ActivityDefinitionUUID activityUUID = job.getActivityDefinitionUUID();
            ProcessInstanceUUID instanceUUID = runtimeAPI.instantiateProcess(processUUID, activityUUID);
            if ("timer".equals(job.getEventType())) {
                Date nextTime;
                String condition = job.getExpression();
                long lastExecution = job.getFireTime();
                if (lastExecution == (nextTime = ProcessUtil.getTimerDate(condition, processUUID, lastExecution)).getTime()) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("A start timer event of process " + processUUID + " ends its cycle.");
                    }
                    eventService.removeJob(job);
                } else {
                    job.renewFireTime(nextTime.getTime());
                    job.unlock();
                    this.jobExecutor.refreshJobExecutor();
                }
            } else {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("An event started a new process instance of " + processUUID);
                }
                if ("message".equals(job.getEventType())) {
                    IncomingEventInstance newIncoming = eventService.getIncomingEvent(instanceUUID, job.getEventName());
                    this.executeEvent(job, newIncoming.getExecutionUUID());
                } else {
                    eventService.removeJob(job);
                }
            }
        }
    }

    private void instantiateStartEventSubProcess(Job job) throws InstanceNotFoundException, ProcessNotFoundException {
        block9: {
            Querier journal = EnvTool.getJournalQueriers();
            Set<Execution> executions = journal.getExecutions(job.getEventSubProcessRootInstanceUUID());
            try {
                Execution current = executions.iterator().next();
                current.abort();
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceAborted(job.getEventSubProcessRootInstanceUUID(), EnvTool.getUserId());
            }
            catch (BonitaRuntimeException e) {
                if (!LOG.isLoggable(Level.WARNING)) break block9;
                LOG.log(Level.WARNING, "The process: " + job.getEventSubProcessRootInstanceUUID() + " has already been aborted by another start event.", e);
            }
        }
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI();
        Map<String, Object> variables = queryRuntimeAPI.getProcessInstanceVariables(job.getEventSubProcessRootInstanceUUID());
        InternalActivityDefinition activity = EnvTool.getJournal().getActivity(job.getActivityDefinitionUUID());
        ProcessDefinitionUUID processUUID = activity.getProcessDefinitionUUID();
        InternalProcessInstance eventSubProcessInstance = this.instantiateEventSubProcess(processUUID, variables, job.getEventSubProcessRootInstanceUUID());
        ProcessInstanceUUID instanceUUID = eventSubProcessInstance.getUUID();
        InternalProcessInstance processInstance = EnvTool.getAllQueriers().getProcessInstance(job.getEventSubProcessRootInstanceUUID());
        if (processInstance.getNbOfAttachments() > 0) {
            DocumentationManager manager = EnvTool.getDocumentationManager();
            List<Document> lastAttachments = DocumentService.getAllDocumentVersions(manager, job.getEventSubProcessRootInstanceUUID());
            for (Document document : lastAttachments) {
                try {
                    manager.attachDocumentTo(processUUID, instanceUUID, document.getId());
                }
                catch (DocumentNotFoundException e) {
                    new BonitaRuntimeException(e);
                }
            }
            eventSubProcessInstance.setNbOfAttachments(processInstance.getNbOfAttachments());
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("An event started a new process instance of " + processUUID);
        }
        EventService eventService = EnvTool.getEventService();
        if ("message".equals(job.getEventType())) {
            IncomingEventInstance newIncoming = eventService.getIncomingEvent(instanceUUID, job.getEventName());
            this.executeEvent(job, newIncoming.getExecutionUUID());
        } else {
            eventService.removeJob(job);
        }
    }

    private InternalProcessInstance instantiateEventSubProcess(ProcessDefinitionUUID processUUID, Map<String, Object> variables, ProcessInstanceUUID rootEventSubProcessInstanceUUID) throws ProcessNotFoundException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting a new instance of process : " + processUUID);
        }
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessInstance rootInstance = journal.getProcessInstance(rootEventSubProcessInstanceUUID);
        Execution rootExecution = ProcessUtil.createProcessInstance(processUUID, variables, null, rootEventSubProcessInstanceUUID, rootInstance.getRootInstanceUUID(), null, null);
        InternalProcessInstance instance = rootExecution.getInstance();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Started: " + instance);
        }
        instance.begin(null);
        return instance;
    }

    private void handleJobsWithExecution(Job job) throws Exception {
        EventService eventService = EnvTool.getEventService();
        eventService.removeJob(job);
        Authentication.setUserId("SYSTEM");
        String executionUUID = job.getExecutionUUID();
        Execution execution = EnvTool.getJournalQueriers().getExecutionWithEventUUID(executionUUID);
        if (execution == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No active execution found for uuid: " + executionUUID);
            }
            throw new BonitaRuntimeException("No active execution found with uuid: " + executionUUID);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Execution found for uuid: " + executionUUID);
        }
        if (!execution.isActive()) {
            execution.unlock();
        }
        String eventPosition = job.getEventPosition();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("eventName", job.getEventName());
        if ("execCnnctAut".equals(eventPosition)) {
            ConnectorExecutor.executeConnectors(execution.getNode(), execution, HookDefinition.Event.automaticOnEnter);
            String eventName = "**bonita_connector_automatic_on_enter_executed**-" + execution.getActivityInstanceId();
            Job sigConnecAutOnEnterexecutedJob = JobBuilder.signalConnectorsAutoOnEnterExecutedJob(eventName, execution.getInstance().getRootInstanceUUID(), execution.getEventUUID(), execution.getInstance().getProcessInstanceUUID());
            eventService.storeJob(sigConnecAutOnEnterexecutedJob);
        } else if ("sigCnnctAutEnd".equals(eventPosition)) {
            execution.signal("sigCnnctAutEnd", parameters);
        } else if ("boundary".equals(eventPosition)) {
            execution.signal("boundary", parameters);
        } else {
            throw new BonitaRuntimeException("Unexpected event position: " + eventPosition);
        }
    }

    private void executeEvent(Job job, String executionId) {
        Authentication.setUserId("SYSTEM");
        String execId = executionId == null ? job.getExecutionUUID() : executionId;
        Execution execution = EnvTool.getJournal().getExecutionWithEventUUID(execId);
        if (execution == null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("No active execution found for identifer: " + execId);
            }
            throw new BonitaRuntimeException("No active execution found for identifer: " + execId);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Execution found for identifer: " + execId);
        }
        if (!"active".equals(execution.getState())) {
            execution.unlock();
        }
        EventService eventService = EnvTool.getEventService();
        eventService.removeJob(job);
        String signal = job.getEventType();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (job.getOutgoingEvent() != null) {
            parameters.putAll(job.getOutgoingEvent().getParameters());
            if (job.getEventSubProcessRootInstanceUUID() == null) {
                eventService.removeEvent(job.getOutgoingEvent());
            }
        } else if ("deadline".equals(job.getEventPosition())) {
            signal = job.getEventPosition();
            parameters.put("id", Long.valueOf(job.getEventName()));
        }
        execution.signal(signal, parameters);
    }

    private void executeEvent(Job job) {
        this.executeEvent(job, null);
    }

    protected void handleException(Environment environment, Job job, Throwable exception) {
        Transaction transaction = environment.get(Transaction.class);
        JobExceptionHandler handler = new JobExceptionHandler(job.getId(), exception, this.jobExecutor.getCommandService());
        transaction.registerSynchronization(handler);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new BonitaRuntimeException("Execution of job (" + job + ") failed: " + exception.getMessage(), exception);
    }
}

