/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventCoupleId;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class GetEventCouples
implements Command<Set<EventCoupleId>> {
    private static final long serialVersionUID = -3820361512043859834L;
    static final Logger LOG = Logger.getLogger(GetEventCouples.class.getName());

    @Override
    public Set<EventCoupleId> execute(Environment environment) throws Exception {
        HashSet<Long> usedIncomings = new HashSet<Long>();
        HashSet<Long> usedOutgoings = new HashSet<Long>();
        EventService eventService = EnvTool.getEventService();
        List<EventCouple> couples = eventService.getCorrelationKeyMessageEventCouples();
        if (couples.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EventCoupleId> result = new HashSet<EventCoupleId>();
        for (EventCouple couple : couples) {
            IncomingEventInstance incoming = couple.getIncoming();
            OutgoingEventInstance outgoing = couple.getOutgoing();
            long incomingId = incoming.getId();
            long outgoingId = outgoing.getId();
            if (usedIncomings.contains(incomingId) || usedOutgoings.contains(outgoingId)) continue;
            usedIncomings.add(incomingId);
            usedOutgoings.add(outgoingId);
            incoming.lock();
            outgoing.lock();
            result.add(new EventCoupleId(incomingId, outgoingId));
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Correlation event matcher: New event couples to execute: " + ((Object)result).toString());
        }
        return result;
    }
}

