/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class GetExecutableJobIds
implements Command<Map<ProcessInstanceUUID, List<Long>>> {
    private static final long serialVersionUID = 117724435875640884L;
    static final Logger LOG = Logger.getLogger(GetExecutableJobIds.class.getName());
    private final List<ProcessInstanceUUID> lockedRootInstances;
    private final int maxResult;

    public GetExecutableJobIds(List<ProcessInstanceUUID> locks, int maxResult) {
        this.lockedRootInstances = locks;
        this.maxResult = maxResult;
    }

    @Override
    public Map<ProcessInstanceUUID, List<Long>> execute(Environment environment) throws Exception {
        EventService eventService = EnvTool.getEventService();
        List<Job> executableJobs = eventService.getExecutableJobs(this.lockedRootInstances, this.maxResult);
        HashMap<ProcessInstanceUUID, List<Long>> jobsbyRoot = new HashMap<ProcessInstanceUUID, List<Long>>();
        for (Job job : executableJobs) {
            ProcessInstanceUUID rootProcessInstanceUUID = job.getRootProcessInstanceUUID();
            ProcessInstanceUUID rootUUID = null;
            rootUUID = rootProcessInstanceUUID != null ? rootProcessInstanceUUID : new ProcessInstanceUUID("start-events");
            ArrayList<Long> list = (ArrayList<Long>)jobsbyRoot.get(rootUUID);
            if (list == null) {
                list = new ArrayList<Long>();
                jobsbyRoot.put(rootUUID, list);
            }
            list.add(job.getId());
            job.lock();
        }
        return jobsbyRoot;
    }
}

